/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.BoundedIOCompactionStrategy;

public class LogFileNumBasedCompactionStrategy
extends BoundedIOCompactionStrategy
implements Comparator<HoodieCompactionOperation> {
    @Override
    public Pair<List<HoodieCompactionOperation>, List<String>> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        Long numThreshold = writeConfig.getCompactionLogFileNumThreshold();
        ArrayList missingPartitions = new ArrayList();
        boolean incrementalTableServiceEnabled = writeConfig.isIncrementalTableServiceEnabled();
        List<HoodieCompactionOperation> filterOperator = operations.stream().filter(e -> {
            if (incrementalTableServiceEnabled && (long)e.getDeltaFilePaths().size() < numThreshold) {
                missingPartitions.add(e.getPartitionPath());
            }
            return (long)e.getDeltaFilePaths().size() >= numThreshold;
        }).sorted(this).collect(Collectors.toList());
        if (incrementalTableServiceEnabled) {
            Pair<List<HoodieCompactionOperation>, List<String>> resPair = super.orderAndFilter(writeConfig, filterOperator, pendingCompactionPlans);
            List compactOperations = (List)resPair.getLeft();
            List innerMissingPartitions = (List)resPair.getRight();
            missingPartitions.addAll(innerMissingPartitions);
            return Pair.of((Object)compactOperations, missingPartitions);
        }
        return super.orderAndFilter(writeConfig, filterOperator, pendingCompactionPlans);
    }

    @Override
    public int compare(HoodieCompactionOperation hco1, HoodieCompactionOperation hco2) {
        return hco2.getDeltaFilePaths().size() - hco1.getDeltaFilePaths().size();
    }
}

