/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.plan.generators;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseTableServicePlanActionExecutor;
import org.apache.hudi.table.action.compact.plan.generators.BaseHoodieCompactionPlanGenerator;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCompactionPlanGenerator<T extends HoodieRecordPayload, I, K, O>
extends BaseHoodieCompactionPlanGenerator<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCompactionPlanGenerator.class);
    private final CompactionStrategy compactionStrategy;

    public HoodieCompactionPlanGenerator(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig, BaseTableServicePlanActionExecutor executor) {
        super(table, engineContext, writeConfig, executor);
        this.compactionStrategy = writeConfig.getCompactionStrategy();
        LOG.info("Compaction Strategy used is: " + this.compactionStrategy.toString());
    }

    @Override
    protected HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, List<HoodieCompactionOperation> operations, Pair<List<String>, List<String>> partitionPair) {
        return this.compactionStrategy.generateCompactionPlan(this.writeConfig, operations, CompactionUtils.getAllPendingCompactionPlans((HoodieTableMetaClient)metaClient).stream().map(Pair::getValue).collect(Collectors.toList()), this.getStrategyParams(), partitionPair);
    }

    @Override
    protected List<String> getPartitions() {
        return this.executor.getPartitions(this.compactionStrategy, TableServiceType.COMPACT);
    }

    @Override
    protected Pair<List<String>, List<String>> filterPartitionPathsByStrategy(List<String> partitionPaths) {
        return this.compactionStrategy.filterPartitionPaths(this.writeConfig, partitionPaths);
    }

    @Override
    protected boolean filterLogCompactionOperations() {
        return false;
    }
}

