/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.plan.generators;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.data.HoodieAccumulator;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseTableServicePlanActionExecutor;
import org.apache.hudi.table.action.compact.CompactHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieCompactionPlanGenerator<T extends HoodieRecordPayload, I, K, O>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieCompactionPlanGenerator.class);
    protected final HoodieTable<T, I, K, O> hoodieTable;
    protected final HoodieWriteConfig writeConfig;
    protected final transient HoodieEngineContext engineContext;
    protected final BaseTableServicePlanActionExecutor executor;

    public BaseHoodieCompactionPlanGenerator(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig, BaseTableServicePlanActionExecutor executor) {
        this.hoodieTable = table;
        this.writeConfig = writeConfig;
        this.engineContext = engineContext;
        this.executor = executor;
    }

    @Nullable
    public HoodieCompactionPlan generateCompactionPlan(String compactionInstant) throws IOException {
        HoodieAccumulator totalLogFiles = this.engineContext.newAccumulator();
        HoodieAccumulator totalFileSlices = this.engineContext.newAccumulator();
        HoodieTableMetaClient metaClient = this.hoodieTable.getMetaClient();
        CompletionTimeQueryView completionTimeQueryView = metaClient.getTimelineLayout().getTimelineFactory().createCompletionTimeQueryView(metaClient);
        List partitionPaths = this.getPartitions();
        int allPartitionSize = partitionPaths.size();
        Pair<List<String>, List<String>> partitionPair = this.filterPartitionPathsByStrategy(partitionPaths);
        partitionPaths = (List)partitionPair.getLeft();
        LOG.info("Strategy: {} matched {} partition paths from all {} partitions for table {}", new Object[]{this.writeConfig.getCompactionStrategy().getClass().getSimpleName(), partitionPaths.size(), allPartitionSize, this.hoodieTable.getConfig().getBasePath()});
        if (partitionPaths.isEmpty()) {
            return null;
        }
        LOG.info("Looking for files to compact in {} partitions for table {}", (Object)partitionPaths.size(), (Object)this.hoodieTable.getConfig().getBasePath());
        LOG.debug("Partitions scanned for compaction: {} for table {}", (Object)partitionPaths, (Object)this.hoodieTable.getConfig().getBasePath());
        this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Looking for files to compact: " + this.writeConfig.getTableName());
        SyncableFileSystemView fileSystemView = (SyncableFileSystemView)this.hoodieTable.getSliceView();
        Set fgIdsInPendingCompactionAndClustering = fileSystemView.getPendingCompactionOperations().map(instantTimeOpPair -> ((CompactionOperation)instantTimeOpPair.getValue()).getFileGroupId()).collect(Collectors.toSet());
        fgIdsInPendingCompactionAndClustering.addAll(fileSystemView.getFileGroupsInPendingClustering().map(Pair::getLeft).collect(Collectors.toSet()));
        if (this.filterLogCompactionOperations()) {
            fgIdsInPendingCompactionAndClustering.addAll(fileSystemView.getPendingLogCompactionOperations().map(instantTimeOpPair -> ((CompactionOperation)instantTimeOpPair.getValue()).getFileGroupId()).collect(Collectors.toList()));
        }
        String lastCompletedInstantTime = ((HoodieInstant)this.hoodieTable.getMetaClient().getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "rollback", "deltacommit"})).filterCompletedInstants().lastInstant().get()).requestedTime();
        LOG.info("Last completed instant time {} for table {}", (Object)lastCompletedInstantTime, (Object)this.hoodieTable.getConfig().getBasePath());
        Option<InstantRange> instantRange = CompactHelpers.getInstance().getInstantRange(metaClient);
        List<HoodieCompactionOperation> operations = this.engineContext.flatMap(partitionPaths, (SerializableFunction & Serializable)partitionPath -> fileSystemView.getLatestFileSlicesStateless(partitionPath).filter(slice -> this.filterFileSlice((FileSlice)slice, lastCompletedInstantTime, fgIdsInPendingCompactionAndClustering, instantRange)).map(s -> {
            List logFiles = s.getLogFiles().filter(logFile -> completionTimeQueryView.isCompletedBefore(compactionInstant, logFile.getDeltaCommitTime())).sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList());
            totalLogFiles.add((long)logFiles.size());
            totalFileSlices.add(1L);
            Option dataFile = s.getBaseFile();
            return new CompactionOperation(dataFile, partitionPath, logFiles, this.writeConfig.getCompactionStrategy().captureMetrics(this.writeConfig, (FileSlice)s));
        }), partitionPaths.size()).stream().map(CompactionUtils::buildHoodieCompactionOperation).collect(Collectors.toList());
        LOG.info("Total of {} compaction operations are retrieved for table {}", (Object)operations.size(), (Object)this.hoodieTable.getConfig().getBasePath());
        LOG.info("Total number of log files {} for table {}", (Object)totalLogFiles.value(), (Object)this.hoodieTable.getConfig().getBasePath());
        LOG.info("Total number of file slices {} for table {}", (Object)totalFileSlices.value(), (Object)this.hoodieTable.getConfig().getBasePath());
        if (operations.isEmpty()) {
            LOG.warn("No operations are retrieved for {} for table {}", (Object)metaClient.getBasePath(), (Object)this.hoodieTable.getConfig().getBasePath());
            return null;
        }
        if (totalLogFiles.value() <= 0L) {
            LOG.warn("No log files are retrieved for {} for table {}", (Object)metaClient.getBasePath(), (Object)this.hoodieTable.getConfig().getBasePath());
            return null;
        }
        HoodieCompactionPlan compactionPlan = this.getCompactionPlan(metaClient, operations, partitionPair);
        ValidationUtils.checkArgument((boolean)compactionPlan.getOperations().stream().noneMatch(op -> fgIdsInPendingCompactionAndClustering.contains(new HoodieFileGroupId(op.getPartitionPath(), op.getFileId()))), () -> "Bad Compaction Plan. FileId MUST NOT have multiple pending compactions. Please fix your strategy implementation. FileIdsWithPendingCompactions :" + fgIdsInPendingCompactionAndClustering + ", Selected workload :" + compactionPlan);
        if (compactionPlan.getOperations().isEmpty()) {
            LOG.warn("After filtering, Nothing to compact for {} for table {}", (Object)metaClient.getBasePath(), (Object)this.hoodieTable.getConfig().getBasePath());
        }
        return compactionPlan;
    }

    protected abstract List<String> getPartitions();

    protected abstract HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient var1, List<HoodieCompactionOperation> var2, Pair<List<String>, List<String>> var3);

    protected abstract boolean filterLogCompactionOperations();

    protected Pair<List<String>, List<String>> filterPartitionPathsByStrategy(List<String> partitionPaths) {
        return Pair.of(partitionPaths, Collections.emptyList());
    }

    protected boolean filterFileSlice(FileSlice fileSlice, String lastCompletedInstantTime, Set<HoodieFileGroupId> pendingFileGroupIds, Option<InstantRange> instantRange) {
        return fileSlice.getLogFiles().count() > 0L && !pendingFileGroupIds.contains(fileSlice.getFileGroupId());
    }

    protected Map<String, String> getStrategyParams() {
        return Collections.emptyMap();
    }
}

