/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.io.AppendHandleFactory;
import org.apache.hudi.io.SingleFileHandleCreateFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.BucketSortBulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BucketIndexBulkInsertPartitioner<T>
extends BucketSortBulkInsertPartitioner<T> {
    public static final Logger LOG = LogManager.getLogger(BucketIndexBulkInsertPartitioner.class);
    private final boolean preserveHoodieMetadata;
    protected final boolean consistentLogicalTimestampEnabled;
    protected final List<String> indexKeyFields;
    protected final List<Boolean> doAppend = new ArrayList<Boolean>();
    protected final List<String> fileIdPfxList = new ArrayList<String>();
    protected boolean isAppendAllowed;

    public BucketIndexBulkInsertPartitioner(HoodieTable table, String sortString, boolean preserveHoodieMetadata) {
        super(table, sortString);
        this.indexKeyFields = Arrays.asList(table.getConfig().getBucketIndexHashField().split(","));
        this.consistentLogicalTimestampEnabled = table.getConfig().isConsistentLogicalTimestampEnabled();
        this.preserveHoodieMetadata = preserveHoodieMetadata;
        this.isAppendAllowed = !table.getMetaClient().getTableConfig().getTableType().equals((Object)HoodieTableType.COPY_ON_WRITE);
    }

    @Override
    public Option<WriteHandleFactory> getWriteHandleFactory(int idx) {
        if (!this.doAppend.get(idx).booleanValue()) {
            return Option.of(new SingleFileHandleCreateFactory(FSUtils.createNewFileId((String)this.getFileIdPfx(idx), (int)0), this.preserveHoodieMetadata));
        }
        if (this.isAppendAllowed) {
            return Option.of(new AppendHandleFactory());
        }
        throw new HoodieNotSupportedException("Multiple bulk inserts into COW with simple bucket and disabled Spark native row writer is not supported, please, use upsert operation, overwrite mode (already written data will be lost), or turn on Spark native row writer.");
    }

    @Override
    public String getFileIdPfx(int partitionId) {
        return this.fileIdPfxList.get(partitionId);
    }
}

