/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.parser;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public abstract class BaseHoodieDateTimeParser
implements Serializable {
    protected final TypedProperties config;
    protected final String configInputDateFormatDelimiter;

    public BaseHoodieDateTimeParser(TypedProperties config) {
        this.config = config;
        this.configInputDateFormatDelimiter = this.initInputDateFormatDelimiter();
    }

    private String initInputDateFormatDelimiter() {
        String inputDateFormatDelimiter = ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX, (boolean)true).trim();
        inputDateFormatDelimiter = inputDateFormatDelimiter.isEmpty() ? "," : inputDateFormatDelimiter;
        return inputDateFormatDelimiter;
    }

    public String getOutputDateFormat() {
        return ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT);
    }

    public abstract Option<DateTimeFormatter> getInputFormatter();

    public abstract DateTimeZone getInputDateTimeZone();

    public abstract DateTimeZone getOutputDateTimeZone();

    public String getConfigInputDateFormatDelimiter() {
        return this.configInputDateFormatDelimiter;
    }
}

