/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieCDCLogger;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMergeHandleWithChangeLog<T, I, K, O>
extends HoodieMergeHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergeHandleWithChangeLog.class);
    protected final HoodieCDCLogger cdcLogger;

    public HoodieMergeHandleWithChangeLog(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, hoodieTable, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
        this.cdcLogger = new HoodieCDCLogger(instantTime, config, hoodieTable.getMetaClient().getTableConfig(), partitionPath, this.storage, this.getWriterSchema(), this.createLogWriter(instantTime, ".cdc", (Option<FileSlice>)Option.empty()), IOUtils.getMaxMemoryPerPartitionMerge(taskContextSupplier, config));
    }

    public HoodieMergeHandleWithChangeLog(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Map<String, HoodieRecord<T>> keyToNewRecords, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, hoodieTable, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, keyGeneratorOpt);
        this.cdcLogger = new HoodieCDCLogger(instantTime, config, hoodieTable.getMetaClient().getTableConfig(), partitionPath, this.storage, this.getWriterSchema(), this.createLogWriter(instantTime, ".cdc", (Option<FileSlice>)Option.empty()), IOUtils.getMaxMemoryPerPartitionMerge(taskContextSupplier, config));
    }

    @Override
    protected boolean writeUpdateRecord(HoodieRecord<T> newRecord, HoodieRecord<T> oldRecord, Option<HoodieRecord> combinedRecordOpt, Schema writerSchema) throws IOException {
        Option savedCombineRecordOp = combinedRecordOpt.map(HoodieRecord::newInstance);
        boolean result = super.writeUpdateRecord(newRecord, oldRecord, combinedRecordOpt, writerSchema);
        if (result) {
            boolean isDelete = HoodieOperation.isDelete((HoodieOperation)newRecord.getOperation());
            Option avroRecordOpt = savedCombineRecordOp.flatMap(r -> HoodieMergeHandleWithChangeLog.toAvroRecord(r, writerSchema, this.config.getPayloadConfig().getProps()));
            this.cdcLogger.put(newRecord, (GenericRecord)oldRecord.getData(), (Option<IndexedRecord>)(isDelete ? Option.empty() : avroRecordOpt));
        }
        return result;
    }

    @Override
    protected void writeInsertRecord(HoodieRecord<T> newRecord) throws IOException {
        Schema schema = this.preserveMetadata ? this.writeSchemaWithMetaFields : this.writeSchema;
        HoodieRecord savedRecord = newRecord.newInstance();
        super.writeInsertRecord(newRecord);
        if (!HoodieOperation.isDelete((HoodieOperation)newRecord.getOperation()) && !savedRecord.isDelete(schema, (Properties)this.config.getPayloadConfig().getProps())) {
            this.cdcLogger.put(newRecord, null, (Option<IndexedRecord>)savedRecord.toIndexedRecord(schema, (Properties)this.config.getPayloadConfig().getProps()).map(HoodieRecord::getData));
        }
    }

    @Override
    public List<WriteStatus> close() {
        List<WriteStatus> writeStatuses = super.close();
        if (this.cdcLogger == null || this.recordsWritten == 0L || this.recordsWritten == this.insertRecordsWritten) {
            return writeStatuses;
        }
        this.cdcLogger.close();
        HoodieWriteStat stat = writeStatuses.get(0).getStat();
        stat.setCdcStats(this.cdcLogger.getCDCWriteStats());
        return writeStatuses;
    }
}

