/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.LogFileSizeBasedCompactionStrategy;

@ConfigClassProperty(name="Compaction Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that control compaction (merging of log files onto a new base files).")
@Immutable
public class HoodieCompactionConfig
extends HoodieConfig {
    public static final ConfigProperty<String> INLINE_COMPACT = ConfigProperty.key((String)"hoodie.compact.inline").defaultValue((Object)"false").withDocumentation("When set to true, compaction service is triggered after each write. While being  simpler operationally, this adds extra latency on the write path.");
    public static final ConfigProperty<String> SCHEDULE_INLINE_COMPACT = ConfigProperty.key((String)"hoodie.compact.schedule.inline").defaultValue((Object)"false").markAdvanced().withDocumentation("When set to true, compaction service will be attempted for inline scheduling after each write. Users have to ensure they have a separate job to run async compaction(execution) for the one scheduled by this writer. Users can choose to set both `hoodie.compact.inline` and `hoodie.compact.schedule.inline` to false and have both scheduling and execution triggered by any async process. But if `hoodie.compact.inline` is set to false, and `hoodie.compact.schedule.inline` is set to true, regular writers will schedule compaction inline, but users are expected to trigger async job for execution. If `hoodie.compact.inline` is set to true, regular writers will do both scheduling and execution inline for compaction");
    public static final ConfigProperty<String> ENABLE_LOG_COMPACTION = ConfigProperty.key((String)"hoodie.log.compaction.enable").defaultValue((Object)"false").markAdvanced().sinceVersion("0.14.0").withDocumentation("By enabling log compaction through this config, log compaction will also get enabled for the metadata table.");
    public static final ConfigProperty<String> INLINE_LOG_COMPACT = ConfigProperty.key((String)"hoodie.log.compaction.inline").defaultValue((Object)"false").markAdvanced().sinceVersion("0.13.0").withDocumentation("When set to true, logcompaction service is triggered after each write. While being  simpler operationally, this adds extra latency on the write path.");
    public static final ConfigProperty<String> INLINE_COMPACT_NUM_DELTA_COMMITS = ConfigProperty.key((String)"hoodie.compact.inline.max.delta.commits").defaultValue((Object)"5").withDocumentation("Number of delta commits after the last compaction, before scheduling of a new compaction is attempted. This config takes effect only for the compaction triggering strategy based on the number of commits, i.e., NUM_COMMITS, NUM_COMMITS_AFTER_LAST_REQUEST, NUM_AND_TIME, and NUM_OR_TIME.");
    public static final ConfigProperty<String> INLINE_COMPACT_TIME_DELTA_SECONDS = ConfigProperty.key((String)"hoodie.compact.inline.max.delta.seconds").defaultValue((Object)String.valueOf(3600)).markAdvanced().withDocumentation("Number of elapsed seconds after the last compaction, before scheduling a new one. This config takes effect only for the compaction triggering strategy based on the elapsed time, i.e., TIME_ELAPSED, NUM_AND_TIME, and NUM_OR_TIME.");
    public static final ConfigProperty<String> INLINE_COMPACT_TRIGGER_STRATEGY = ConfigProperty.key((String)"hoodie.compact.inline.trigger.strategy").defaultValue((Object)CompactionTriggerStrategy.NUM_COMMITS.name()).markAdvanced().withDocumentation(CompactionTriggerStrategy.class);
    public static final ConfigProperty<String> PARQUET_SMALL_FILE_LIMIT = ConfigProperty.key((String)"hoodie.parquet.small.file.limit").defaultValue((Object)String.valueOf(0x6400000)).markAdvanced().withDocumentation("During upsert operation, we opportunistically expand existing small files on storage, instead of writing new files, to keep number of files to an optimum. This config sets the file size limit below which a file on storage  becomes a candidate to be selected as such a `small file`. By default, treat any file <= 100MB as a small file. Also note that if this set <= 0, will not try to get small files and directly write new files");
    public static final ConfigProperty<String> RECORD_SIZE_ESTIMATION_THRESHOLD = ConfigProperty.key((String)"hoodie.record.size.estimation.threshold").defaultValue((Object)"1.0").markAdvanced().withDocumentation("We use the previous commits' metadata to calculate the estimated record size and use it  to bin pack records into partitions. If the previous commit is too small to make an accurate estimation,  Hudi will search commits in the reverse order, until we find a commit that has totalBytesWritten  larger than (PARQUET_SMALL_FILE_LIMIT_BYTES * this_threshold)");
    public static final ConfigProperty<String> TARGET_IO_PER_COMPACTION_IN_MB = ConfigProperty.key((String)"hoodie.compaction.target.io").defaultValue((Object)String.valueOf(512000)).markAdvanced().withDocumentation("Amount of MBs to spend during compaction run for the LogFileSizeBasedCompactionStrategy. This value helps bound ingestion latency while compaction is run inline mode.");
    public static final ConfigProperty<Long> COMPACTION_LOG_FILE_SIZE_THRESHOLD = ConfigProperty.key((String)"hoodie.compaction.logfile.size.threshold").defaultValue((Object)0L).markAdvanced().withDocumentation("Only if the log file size is greater than the threshold in bytes, the file group will be compacted.");
    public static final ConfigProperty<Long> COMPACTION_LOG_FILE_NUM_THRESHOLD = ConfigProperty.key((String)"hoodie.compaction.logfile.num.threshold").defaultValue((Object)0L).markAdvanced().sinceVersion("0.13.0").withDocumentation("Only if the log file num is greater than the threshold, the file group will be compacted.");
    public static final ConfigProperty<String> COMPACTION_STRATEGY = ConfigProperty.key((String)"hoodie.compaction.strategy").defaultValue((Object)LogFileSizeBasedCompactionStrategy.class.getName()).markAdvanced().withDocumentation("Compaction strategy decides which file groups are picked up for compaction during each compaction run. By default. Hudi picks the log file with most accumulated unmerged data. The strategy can be composed with multiple strategies by concatenating the class names with ','.");
    public static final ConfigProperty<String> TARGET_PARTITIONS_PER_DAYBASED_COMPACTION = ConfigProperty.key((String)"hoodie.compaction.daybased.target.partitions").defaultValue((Object)"10").markAdvanced().withDocumentation("Used by org.apache.hudi.io.compact.strategy.DayBasedCompactionStrategy to denote the number of latest partitions to compact during a compaction run.");
    public static final ConfigProperty<String> COMPACTION_SPECIFY_PARTITION_PATH_REGEX = ConfigProperty.key((String)"hoodie.compaction.partition.path.regex").noDefaultValue().markAdvanced().withDocumentation("Used to specify the partition path regex for compaction. Only partitions that match the regex will be compacted. Only be used when configure PartitionRegexBasedCompactionStrategy.");
    public static final ConfigProperty<String> COPY_ON_WRITE_INSERT_SPLIT_SIZE = ConfigProperty.key((String)"hoodie.copyonwrite.insert.split.size").defaultValue((Object)String.valueOf(500000)).markAdvanced().withDocumentation("Number of inserts assigned for each partition/bucket for writing. We based the default on writing out 100MB files, with at least 1kb records (100K records per file), and   over provision to 500K. As long as auto-tuning of splits is turned on, this only affects the first   write, where there is no history to learn record sizes from.");
    public static final ConfigProperty<String> COPY_ON_WRITE_AUTO_SPLIT_INSERTS = ConfigProperty.key((String)"hoodie.copyonwrite.insert.auto.split").defaultValue((Object)"true").markAdvanced().withDocumentation("Config to control whether we control insert split sizes automatically based on average record sizes. It's recommended to keep this turned on, since hand tuning is otherwise extremely cumbersome.");
    public static final ConfigProperty<String> COPY_ON_WRITE_RECORD_SIZE_ESTIMATE = ConfigProperty.key((String)"hoodie.copyonwrite.record.size.estimate").defaultValue((Object)String.valueOf(1024)).markAdvanced().withDocumentation("The average record size. If not explicitly specified, hudi will compute the record size estimate compute dynamically based on commit metadata.  This is critical in computing the insert parallelism and bin-packing inserts into small files.");
    public static final ConfigProperty<String> LOG_COMPACTION_BLOCKS_THRESHOLD = ConfigProperty.key((String)"hoodie.log.compaction.blocks.threshold").defaultValue((Object)"5").markAdvanced().sinceVersion("0.13.0").withDocumentation("Log compaction can be scheduled if the no. of log blocks crosses this threshold value. This is effective only when log compaction is enabled via " + INLINE_LOG_COMPACT.key());
    @Deprecated
    public static final String INLINE_COMPACT_PROP = INLINE_COMPACT.key();
    @Deprecated
    public static final String INLINE_COMPACT_NUM_DELTA_COMMITS_PROP = INLINE_COMPACT_NUM_DELTA_COMMITS.key();
    @Deprecated
    public static final String INLINE_COMPACT_TIME_DELTA_SECONDS_PROP = INLINE_COMPACT_TIME_DELTA_SECONDS.key();
    @Deprecated
    public static final String INLINE_COMPACT_TRIGGER_STRATEGY_PROP = INLINE_COMPACT_TRIGGER_STRATEGY.key();
    @Deprecated
    public static final String PARQUET_SMALL_FILE_LIMIT_BYTES = PARQUET_SMALL_FILE_LIMIT.key();
    @Deprecated
    public static final String DEFAULT_PARQUET_SMALL_FILE_LIMIT_BYTES = (String)PARQUET_SMALL_FILE_LIMIT.defaultValue();
    @Deprecated
    public static final String RECORD_SIZE_ESTIMATION_THRESHOLD_PROP = RECORD_SIZE_ESTIMATION_THRESHOLD.key();
    @Deprecated
    public static final String DEFAULT_RECORD_SIZE_ESTIMATION_THRESHOLD = (String)RECORD_SIZE_ESTIMATION_THRESHOLD.defaultValue();
    @Deprecated
    public static final String COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE = COPY_ON_WRITE_INSERT_SPLIT_SIZE.key();
    @Deprecated
    public static final String DEFAULT_COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE = (String)COPY_ON_WRITE_INSERT_SPLIT_SIZE.defaultValue();
    @Deprecated
    public static final String COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS = COPY_ON_WRITE_AUTO_SPLIT_INSERTS.key();
    @Deprecated
    public static final String DEFAULT_COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS = (String)COPY_ON_WRITE_AUTO_SPLIT_INSERTS.defaultValue();
    @Deprecated
    public static final String COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE = COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.key();
    @Deprecated
    public static final String DEFAULT_COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE = (String)COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.defaultValue();
    @Deprecated
    public static final String TARGET_IO_PER_COMPACTION_IN_MB_PROP = TARGET_IO_PER_COMPACTION_IN_MB.key();
    @Deprecated
    public static final String DEFAULT_TARGET_IO_PER_COMPACTION_IN_MB = (String)TARGET_IO_PER_COMPACTION_IN_MB.defaultValue();
    @Deprecated
    public static final String COMPACTION_STRATEGY_PROP = COMPACTION_STRATEGY.key();
    @Deprecated
    public static final String DEFAULT_COMPACTION_STRATEGY = (String)COMPACTION_STRATEGY.defaultValue();
    @Deprecated
    public static final String COMPACTION_LAZY_BLOCK_READ_ENABLED_PROP = HoodieReaderConfig.COMPACTION_LAZY_BLOCK_READ_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_COMPACTION_LAZY_BLOCK_READ_ENABLED = (String)HoodieReaderConfig.COMPACTION_LAZY_BLOCK_READ_ENABLE.defaultValue();
    @Deprecated
    public static final String COMPACTION_REVERSE_LOG_READ_ENABLED_PROP = HoodieReaderConfig.COMPACTION_REVERSE_LOG_READ_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_COMPACTION_REVERSE_LOG_READ_ENABLED = (String)HoodieReaderConfig.COMPACTION_REVERSE_LOG_READ_ENABLE.defaultValue();
    @Deprecated
    private static final String DEFAULT_INLINE_COMPACT = (String)INLINE_COMPACT.defaultValue();
    @Deprecated
    private static final String DEFAULT_INLINE_COMPACT_NUM_DELTA_COMMITS = (String)INLINE_COMPACT_NUM_DELTA_COMMITS.defaultValue();
    @Deprecated
    private static final String DEFAULT_INLINE_COMPACT_TIME_DELTA_SECONDS = (String)INLINE_COMPACT_TIME_DELTA_SECONDS.defaultValue();
    @Deprecated
    private static final String DEFAULT_INLINE_COMPACT_TRIGGER_STRATEGY = (String)INLINE_COMPACT_TRIGGER_STRATEGY.defaultValue();
    @Deprecated
    public static final String TARGET_PARTITIONS_PER_DAYBASED_COMPACTION_PROP = TARGET_PARTITIONS_PER_DAYBASED_COMPACTION.key();
    @Deprecated
    public static final String DEFAULT_TARGET_PARTITIONS_PER_DAYBASED_COMPACTION = (String)TARGET_PARTITIONS_PER_DAYBASED_COMPACTION.defaultValue();

    private HoodieCompactionConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieCompactionConfig compactionConfig = new HoodieCompactionConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.compactionConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.compactionConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withInlineCompaction(Boolean inlineCompaction) {
            this.compactionConfig.setValue(INLINE_COMPACT, String.valueOf(inlineCompaction));
            return this;
        }

        public Builder withScheduleInlineCompaction(Boolean scheduleAsyncCompaction) {
            this.compactionConfig.setValue(SCHEDULE_INLINE_COMPACT, String.valueOf(scheduleAsyncCompaction));
            return this;
        }

        public Builder withInlineLogCompaction(Boolean inlineLogCompaction) {
            this.compactionConfig.setValue(INLINE_LOG_COMPACT, String.valueOf(inlineLogCompaction));
            return this;
        }

        public Builder withInlineCompactionTriggerStrategy(CompactionTriggerStrategy compactionTriggerStrategy) {
            this.compactionConfig.setValue(INLINE_COMPACT_TRIGGER_STRATEGY, compactionTriggerStrategy.name());
            return this;
        }

        public Builder compactionSmallFileSize(long smallFileLimitBytes) {
            this.compactionConfig.setValue(PARQUET_SMALL_FILE_LIMIT, String.valueOf(smallFileLimitBytes));
            return this;
        }

        public Builder compactionRecordSizeEstimateThreshold(double threshold) {
            this.compactionConfig.setValue(RECORD_SIZE_ESTIMATION_THRESHOLD, String.valueOf(threshold));
            return this;
        }

        public Builder insertSplitSize(int insertSplitSize) {
            this.compactionConfig.setValue(COPY_ON_WRITE_INSERT_SPLIT_SIZE, String.valueOf(insertSplitSize));
            return this;
        }

        public Builder autoTuneInsertSplits(boolean autoTuneInsertSplits) {
            this.compactionConfig.setValue(COPY_ON_WRITE_AUTO_SPLIT_INSERTS, String.valueOf(autoTuneInsertSplits));
            return this;
        }

        public Builder approxRecordSize(int recordSizeEstimate) {
            this.compactionConfig.setValue(COPY_ON_WRITE_RECORD_SIZE_ESTIMATE, String.valueOf(recordSizeEstimate));
            return this;
        }

        public Builder withCompactionStrategy(CompactionStrategy ... compactionStrategies) {
            StringBuilder compactionStrategyBuilder = new StringBuilder();
            for (CompactionStrategy compactionStrategy : compactionStrategies) {
                compactionStrategyBuilder.append(compactionStrategy.getClass().getName()).append(",");
            }
            if (compactionStrategyBuilder.length() > 0) {
                compactionStrategyBuilder.deleteCharAt(compactionStrategyBuilder.length() - 1);
            }
            this.compactionConfig.setValue(COMPACTION_STRATEGY, compactionStrategyBuilder.toString());
            return this;
        }

        public Builder withTargetIOPerCompactionInMB(long targetIOPerCompactionInMB) {
            this.compactionConfig.setValue(TARGET_IO_PER_COMPACTION_IN_MB, String.valueOf(targetIOPerCompactionInMB));
            return this;
        }

        public Builder withMaxNumDeltaCommitsBeforeCompaction(int maxNumDeltaCommitsBeforeCompaction) {
            this.compactionConfig.setValue(INLINE_COMPACT_NUM_DELTA_COMMITS, String.valueOf(maxNumDeltaCommitsBeforeCompaction));
            return this;
        }

        public Builder withMaxDeltaSecondsBeforeCompaction(int maxDeltaSecondsBeforeCompaction) {
            this.compactionConfig.setValue(INLINE_COMPACT_TIME_DELTA_SECONDS, String.valueOf(maxDeltaSecondsBeforeCompaction));
            return this;
        }

        public Builder withCompactionLazyBlockReadEnabled(Boolean compactionLazyBlockReadEnabled) {
            this.compactionConfig.setValue(HoodieReaderConfig.COMPACTION_LAZY_BLOCK_READ_ENABLE, String.valueOf(compactionLazyBlockReadEnabled));
            return this;
        }

        public Builder withCompactionReverseLogReadEnabled(Boolean compactionReverseLogReadEnabled) {
            this.compactionConfig.setValue(HoodieReaderConfig.COMPACTION_REVERSE_LOG_READ_ENABLE, String.valueOf(compactionReverseLogReadEnabled));
            return this;
        }

        public Builder withTargetPartitionsPerDayBasedCompaction(int targetPartitionsPerCompaction) {
            this.compactionConfig.setValue(TARGET_PARTITIONS_PER_DAYBASED_COMPACTION, String.valueOf(targetPartitionsPerCompaction));
            return this;
        }

        public Builder withLogFileSizeThresholdBasedCompaction(long logFileSizeThreshold) {
            this.compactionConfig.setValue(COMPACTION_LOG_FILE_SIZE_THRESHOLD, String.valueOf(logFileSizeThreshold));
            return this;
        }

        public Builder withCompactionLogFileNumThreshold(int logFileNumThreshold) {
            this.compactionConfig.setValue(COMPACTION_LOG_FILE_NUM_THRESHOLD, String.valueOf(logFileNumThreshold));
            return this;
        }

        public Builder withLogCompactionEnabled(boolean enableLogCompaction) {
            this.compactionConfig.setValue(ENABLE_LOG_COMPACTION, Boolean.toString(enableLogCompaction));
            return this;
        }

        public Builder withLogCompactionBlocksThreshold(int logCompactionBlocksThreshold) {
            this.compactionConfig.setValue(LOG_COMPACTION_BLOCKS_THRESHOLD, String.valueOf(logCompactionBlocksThreshold));
            return this;
        }

        public Builder withEnableOptimizedLogBlocksScan(String enableOptimizedLogBlocksScan) {
            this.compactionConfig.setValue(HoodieReaderConfig.ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN, enableOptimizedLogBlocksScan);
            return this;
        }

        public Builder withCompactionSpecifyPartitionPathRegex(String partitionPathRegex) {
            this.compactionConfig.setValue(COMPACTION_SPECIFY_PARTITION_PATH_REGEX, partitionPathRegex);
            return this;
        }

        public HoodieCompactionConfig build() {
            this.compactionConfig.setDefaults(HoodieCompactionConfig.class.getName());
            this.compactionConfig.setDefaults(HoodieReaderConfig.class.getName());
            return this.compactionConfig;
        }
    }
}

