/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferWriterConflictResolutionStrategy
extends SimpleConcurrentFileWritesConflictResolutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PreferWriterConflictResolutionStrategy.class);

    @Override
    public Stream<HoodieInstant> getCandidateInstants(HoodieTableMetaClient metaClient, HoodieInstant currentInstant, Option<HoodieInstant> lastSuccessfulInstant) {
        HoodieActiveTimeline activeTimeline = metaClient.reloadActiveTimeline();
        if (ClusteringUtils.isClusteringInstant((HoodieTimeline)activeTimeline, (HoodieInstant)currentInstant, (InstantGenerator)metaClient.getInstantGenerator()) || "compaction".equals(currentInstant.getAction())) {
            return this.getCandidateInstantsForTableServicesCommits(activeTimeline, currentInstant);
        }
        return this.getCandidateInstantsForNonTableServicesCommits(activeTimeline, currentInstant);
    }

    private Stream<HoodieInstant> getCandidateInstantsForNonTableServicesCommits(HoodieActiveTimeline activeTimeline, HoodieInstant currentInstant) {
        List completedCommitsInstants = activeTimeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "replacecommit", "compaction", "deltacommit"})).filterCompletedInstants().findInstantsModifiedAfterByCompletionTime(currentInstant.requestedTime()).getInstantsOrderedByCompletionTime().collect(Collectors.toList());
        LOG.info(String.format("Instants that may have conflict with %s are %s", currentInstant, completedCommitsInstants));
        return completedCommitsInstants.stream();
    }

    private Stream<HoodieInstant> getCandidateInstantsForTableServicesCommits(HoodieActiveTimeline activeTimeline, HoodieInstant currentInstant) {
        Stream completedCommitsStream = activeTimeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "replacecommit", "compaction", "deltacommit"})).filterCompletedInstants().findInstantsModifiedAfterByCompletionTime(currentInstant.requestedTime()).getInstantsAsStream();
        Stream inflightIngestionCommitsStream = activeTimeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit"})).filterInflights().getInstantsAsStream();
        List instantsToConsider = Stream.concat(completedCommitsStream, inflightIngestionCommitsStream).sorted(Comparator.comparing(o -> o.getCompletionTime())).collect(Collectors.toList());
        LOG.info(String.format("Instants that may have conflict with %s are %s", currentInstant, instantsToConsider));
        return instantsToConsider.stream();
    }

    @Override
    public boolean isPreCommitRequired() {
        return true;
    }
}

