/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeHandler;

public class SevenToEightUpgradeHandler
implements UpgradeHandler {
    @Override
    public Map<ConfigProperty, String> upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTableConfig tableConfig = upgradeDowngradeHelper.getTable(config, context).getMetaClient().getTableConfig();
        if (tableConfig.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
            String payloadClassName = tableConfig.getPayloadClass();
            String propToAdd = null != payloadClassName ? (payloadClassName.equals(OverwriteWithLatestAvroPayload.class.getName()) ? RecordMergeMode.OVERWRITE_WITH_LATEST.toString() : (payloadClassName.equals(DefaultHoodieRecordPayload.class.getName()) ? RecordMergeMode.EVENT_TIME_ORDERING.toString() : RecordMergeMode.CUSTOM.toString())) : RecordMergeMode.CUSTOM.toString();
            ValidationUtils.checkState((null != propToAdd ? 1 : 0) != 0, (String)String.format("Couldn't infer (%s) from (%s) class name", HoodieTableConfig.RECORD_MERGE_MODE.key(), payloadClassName));
            Hashtable<ConfigProperty, String> tablePropsToAdd = new Hashtable<ConfigProperty, String>();
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, propToAdd);
            return tablePropsToAdd;
        }
        return Collections.emptyMap();
    }
}

