/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.conflict.detection.DirectMarkerBasedDetectionStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.ConflictDetectionUtils;
import org.apache.hudi.table.marker.WriteMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectWriteMarkers
extends WriteMarkers {
    private static final Logger LOG = LoggerFactory.getLogger(DirectWriteMarkers.class);
    private final transient HoodieStorage storage;

    public DirectWriteMarkers(HoodieStorage storage, String basePath, String markerFolderPath, String instantTime) {
        super(basePath, markerFolderPath, instantTime);
        this.storage = storage;
    }

    public DirectWriteMarkers(HoodieTable table, String instantTime) {
        this(table.getStorage(), table.getMetaClient().getBasePath().toString(), table.getMetaClient().getMarkerFolderPath(instantTime), instantTime);
    }

    @Override
    public boolean deleteMarkerDir(HoodieEngineContext context, int parallelism) {
        return FSUtils.deleteDir((HoodieEngineContext)context, (HoodieStorage)this.storage, (StoragePath)this.markerDirPath, (int)parallelism);
    }

    @Override
    public boolean doesMarkerDirExist() throws IOException {
        return this.storage.exists(this.markerDirPath);
    }

    @Override
    public Set<String> createdAndMergedDataPaths(HoodieEngineContext context, int parallelism) throws IOException {
        HashSet<String> dataFiles = new HashSet<String>();
        List topLevelInfoList = this.storage.listDirectEntries(this.markerDirPath);
        ArrayList<String> subDirectories = new ArrayList<String>();
        for (StoragePathInfo topLevelInfo : topLevelInfoList) {
            if (topLevelInfo.isFile()) {
                String pathStr = topLevelInfo.getPath().toString();
                if (!pathStr.contains(".marker") || pathStr.endsWith(IOType.APPEND.name())) continue;
                dataFiles.add(this.translateMarkerToDataPath(pathStr));
                continue;
            }
            subDirectories.add(topLevelInfo.getPath().toString());
        }
        if (subDirectories.size() > 0) {
            parallelism = Math.min(subDirectories.size(), parallelism);
            StorageConfiguration storageConf = this.storage.getConf();
            context.setJobStatus(this.getClass().getSimpleName(), "Obtaining marker files for all created, merged paths");
            dataFiles.addAll(context.flatMap(subDirectories, (SerializableFunction & Serializable)directory -> {
                Path path = new Path(directory);
                FileSystem fileSystem = HadoopFSUtils.getFs((Path)path, (Configuration)((Configuration)storageConf.unwrapAs(Configuration.class)));
                RemoteIterator itr = fileSystem.listFiles(path, true);
                ArrayList<String> result = new ArrayList<String>();
                while (itr.hasNext()) {
                    FileStatus status = (FileStatus)itr.next();
                    String pathStr = status.getPath().toString();
                    if (!pathStr.contains(".marker") || pathStr.endsWith(IOType.APPEND.name())) continue;
                    result.add(this.translateMarkerToDataPath(pathStr));
                }
                return result.stream();
            }, parallelism));
        }
        return dataFiles;
    }

    private String translateMarkerToDataPath(String markerPath) {
        String rPath = MarkerUtils.stripMarkerFolderPrefix((String)markerPath, (String)this.basePath, (String)this.instantTime);
        return DirectWriteMarkers.stripMarkerSuffix(rPath);
    }

    @Override
    public Set<String> allMarkerFilePaths() throws IOException {
        HashSet<String> markerFiles = new HashSet<String>();
        if (this.doesMarkerDirExist()) {
            FSUtils.processFiles((HoodieStorage)this.storage, (String)this.markerDirPath.toString(), fileStatus -> {
                markerFiles.add(MarkerUtils.stripMarkerFolderPrefix((String)fileStatus.getPath().toString(), (String)this.basePath, (String)this.instantTime));
                return true;
            }, (boolean)false);
        }
        return markerFiles;
    }

    public Option<StoragePath> create(String markerName) {
        return this.create(new StoragePath(this.markerDirPath, markerName), true);
    }

    @Override
    protected Option<StoragePath> create(String partitionPath, String fileName, IOType type, boolean checkIfExists) {
        return this.create(this.getMarkerPath(partitionPath, fileName, type), checkIfExists);
    }

    @Override
    public Option<StoragePath> createWithEarlyConflictDetection(String partitionPath, String dataFileName, IOType type, boolean checkIfExists, HoodieWriteConfig config, String fileId, HoodieActiveTimeline activeTimeline) {
        String strategyClassName = config.getEarlyConflictDetectionStrategyClassName();
        if (!ReflectionUtils.isSubClass((String)strategyClassName, DirectMarkerBasedDetectionStrategy.class)) {
            LOG.warn("Cannot use " + strategyClassName + " for direct markers.");
            strategyClassName = ConflictDetectionUtils.getDefaultEarlyConflictDetectionStrategy(MarkerType.DIRECT);
            LOG.warn("Falling back to " + strategyClassName);
        }
        DirectMarkerBasedDetectionStrategy strategy = (DirectMarkerBasedDetectionStrategy)ReflectionUtils.loadClass((String)strategyClassName, (Class[])new Class[]{HoodieStorage.class, String.class, String.class, String.class, HoodieActiveTimeline.class, HoodieWriteConfig.class}, (Object[])new Object[]{this.storage, partitionPath, fileId, this.instantTime, activeTimeline, config});
        strategy.detectAndResolveConflictIfNecessary();
        return this.create(this.getMarkerPath(partitionPath, dataFileName, type), checkIfExists);
    }

    private Option<StoragePath> create(StoragePath markerPath, boolean checkIfExists) {
        HoodieTimer timer = HoodieTimer.start();
        StoragePath dirPath = markerPath.getParent();
        try {
            if (!this.storage.exists(dirPath)) {
                this.storage.createDirectory(dirPath);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + dirPath, e);
        }
        try {
            if (checkIfExists && this.storage.exists(markerPath)) {
                LOG.warn("Marker Path=" + markerPath + " already exists, cancel creation");
                return Option.empty();
            }
            LOG.info("Creating Marker Path=" + markerPath);
            this.storage.create(markerPath, false).close();
        }
        catch (IOException e) {
            throw new HoodieException("Failed to create marker file " + markerPath, (Throwable)e);
        }
        LOG.info("[direct] Created marker file " + markerPath.toString() + " in " + timer.endTimer() + " ms");
        return Option.of((Object)markerPath);
    }
}

