/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.marker.MarkerBasedRollbackUtils;
import org.apache.hudi.table.marker.WriteMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerBasedRollbackStrategy<T, I, K, O>
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerBasedRollbackStrategy.class);
    protected final HoodieTable<?, ?, ?, ?> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    protected final String instantTime;

    public MarkerBasedRollbackStrategy(HoodieTable<?, ?, ?, ?> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        this.table = table;
        this.context = context;
        this.basePath = table.getMetaClient().getBasePath().toString();
        this.config = config;
        this.instantTime = instantTime;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            List<String> markerPaths = MarkerBasedRollbackUtils.getAllMarkerPaths(this.table, this.context, instantToRollback.getTimestamp(), this.config.getRollbackParallelism());
            int parallelism = Math.max(Math.min(markerPaths.size(), this.config.getRollbackParallelism()), 1);
            return this.context.map(markerPaths, (SerializableFunction & Serializable)markerFilePath -> {
                String typeStr = markerFilePath.substring(markerFilePath.lastIndexOf(".") + 1);
                IOType type = IOType.valueOf((String)typeStr);
                String filePathStr = WriteMarkers.stripMarkerSuffix(markerFilePath);
                Path filePath = new Path(this.basePath, filePathStr);
                String partitionPath = HadoopFSUtils.getRelativePartitionPath((Path)new Path(this.basePath), (Path)filePath.getParent());
                String fileId = HadoopFSUtils.getFileIdFromFilePath((Path)filePath);
                switch (type) {
                    case MERGE: 
                    case CREATE: {
                        return new HoodieRollbackRequest(partitionPath, fileId, instantToRollback.getTimestamp(), Collections.singletonList(filePath.toString()), Collections.emptyMap());
                    }
                    case APPEND: {
                        return new HoodieRollbackRequest(partitionPath, fileId, instantToRollback.getTimestamp(), Collections.emptyList(), Collections.singletonMap(filePath.toString(), 1L));
                    }
                }
                throw new HoodieRollbackException("Unknown marker type, during rollback of " + instantToRollback);
            }, parallelism);
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Error rolling back using marker files written for " + instantToRollback, e);
        }
    }
}

