/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.timeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.model.HoodieLSMTimelineInstant;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLSMTimelineManifest;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.LSMTimeline;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.io.hadoop.HoodieAvroParquetReader;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSMTimelineWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LSMTimelineWriter.class);
    public static final int FILE_LAYER_ZERO = 0;
    public static final long MAX_FILE_SIZE_IN_BYTES = 1048576000L;
    private final HoodieWriteConfig config;
    private final TaskContextSupplier taskContextSupplier;
    private final HoodieTableMetaClient metaClient;
    private HoodieWriteConfig writeConfig;

    private LSMTimelineWriter(HoodieWriteConfig config, HoodieTable<?, ?, ?, ?> table) {
        this(config, table.getTaskContextSupplier(), table.getMetaClient());
    }

    private LSMTimelineWriter(HoodieWriteConfig config, TaskContextSupplier taskContextSupplier, HoodieTableMetaClient metaClient) {
        this.config = config;
        this.taskContextSupplier = taskContextSupplier;
        this.metaClient = metaClient;
    }

    public static LSMTimelineWriter getInstance(HoodieWriteConfig config, HoodieTable<?, ?, ?, ?> table) {
        return new LSMTimelineWriter(config, table);
    }

    public static LSMTimelineWriter getInstance(HoodieWriteConfig config, TaskContextSupplier taskContextSupplier, HoodieTableMetaClient metaClient) {
        return new LSMTimelineWriter(config, taskContextSupplier, metaClient);
    }

    public void write(List<ActiveAction> activeActions, Option<Consumer<ActiveAction>> preWriteCallback, Option<Consumer<Exception>> exceptionHandler) throws HoodieCommitException {
        ValidationUtils.checkArgument((!activeActions.isEmpty() ? 1 : 0) != 0, (String)"The instant actions to write should not be empty");
        StoragePath filePath = new StoragePath(this.metaClient.getArchivePath(), LSMTimelineWriter.newFileName(activeActions.get(0).getInstantTime(), activeActions.get(activeActions.size() - 1).getInstantTime(), 0));
        try (HoodieFileWriter writer = this.openWriter(filePath);){
            Schema wrapperSchema = HoodieLSMTimelineInstant.getClassSchema();
            LOG.info("Writing schema " + wrapperSchema.toString());
            for (ActiveAction activeAction : activeActions) {
                try {
                    preWriteCallback.ifPresent(callback -> callback.accept(activeAction));
                    HoodieLSMTimelineInstant metaEntry = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)activeAction, (HoodieTableMetaClient)this.metaClient);
                    writer.write(metaEntry.getInstantTime(), (HoodieRecord)new HoodieAvroIndexedRecord((IndexedRecord)metaEntry), wrapperSchema);
                }
                catch (Exception e) {
                    LOG.error("Failed to write instant: " + activeAction.getInstantTime(), (Throwable)e);
                    exceptionHandler.ifPresent(handler -> handler.accept(e));
                }
            }
        }
        catch (Exception e) {
            throw new HoodieCommitException("Failed to write commits", e);
        }
        try {
            this.updateManifest(filePath.getName());
        }
        catch (Exception e) {
            throw new HoodieCommitException("Failed to update archiving manifest", e);
        }
    }

    public void updateManifest(String fileToAdd) throws IOException {
        this.updateManifest(Collections.emptyList(), fileToAdd);
    }

    public void updateManifest(List<String> filesToRemove, String fileToAdd) throws IOException {
        int latestVersion = LSMTimeline.latestSnapshotVersion((HoodieTableMetaClient)this.metaClient);
        HoodieLSMTimelineManifest latestManifest = LSMTimeline.latestSnapshotManifest((HoodieTableMetaClient)this.metaClient, (int)latestVersion);
        HoodieLSMTimelineManifest newManifest = latestManifest.copy(filesToRemove);
        newManifest.addFile(this.getFileEntry(fileToAdd));
        this.createManifestFile(newManifest, latestVersion);
    }

    private void createManifestFile(HoodieLSMTimelineManifest manifest, int currentVersion) throws IOException {
        byte[] content = StringUtils.getUTF8Bytes((String)manifest.toJsonString());
        int newVersion = currentVersion < 0 ? 1 : currentVersion + 1;
        StoragePath manifestFilePath = LSMTimeline.getManifestFilePath((HoodieTableMetaClient)this.metaClient, (int)newVersion);
        this.metaClient.getStorage().createImmutableFileInPath(manifestFilePath, Option.of((Object)content));
        this.updateVersionFile(newVersion);
    }

    private void updateVersionFile(int newVersion) throws IOException {
        byte[] content = StringUtils.getUTF8Bytes((String)String.valueOf(newVersion));
        StoragePath versionFilePath = LSMTimeline.getVersionFilePath((HoodieTableMetaClient)this.metaClient);
        this.metaClient.getStorage().deleteFile(versionFilePath);
        this.metaClient.getStorage().createImmutableFileInPath(versionFilePath, Option.of((Object)content));
    }

    @VisibleForTesting
    public void compactAndClean(HoodieEngineContext context) throws IOException {
        HoodieLSMTimelineManifest latestManifest = LSMTimeline.latestSnapshotManifest((HoodieTableMetaClient)this.metaClient);
        int layer = 0;
        Option<String> compactedFileName = this.doCompact(latestManifest, layer);
        while (compactedFileName.isPresent()) {
            latestManifest.addFile(this.getFileEntry((String)compactedFileName.get()));
            compactedFileName = this.doCompact(latestManifest, ++layer);
        }
        this.clean(context, layer);
    }

    private Option<String> doCompact(HoodieLSMTimelineManifest manifest, int layer) throws IOException {
        List<HoodieLSMTimelineManifest.LSMFileEntry> files = manifest.getFiles().stream().filter(file -> LSMTimeline.isFileFromLayer((String)file.getFileName(), (int)layer)).collect(Collectors.toList());
        int compactionBatchSize = this.config.getTimelineCompactionBatchSize();
        if (files.size() >= compactionBatchSize) {
            files.sort(HoodieLSMTimelineManifest.LSMFileEntry::compareTo);
            List<String> candidateFiles = this.getCandidateFiles(files, compactionBatchSize);
            if (candidateFiles.size() < 2) {
                return Option.empty();
            }
            String compactedFileName = LSMTimelineWriter.compactedFileName(candidateFiles);
            this.compactFiles(candidateFiles, compactedFileName);
            this.updateManifest(candidateFiles, compactedFileName);
            LOG.info("Finishes compaction of source files: " + candidateFiles);
            return Option.of((Object)compactedFileName);
        }
        return Option.empty();
    }

    public void compactFiles(List<String> candidateFiles, String compactedFileName) {
        LOG.info("Starting to compact source files.");
        try (HoodieFileWriter writer = this.openWriter(new StoragePath(this.metaClient.getArchivePath(), compactedFileName));){
            for (String fileName : candidateFiles) {
                HoodieAvroParquetReader reader = (HoodieAvroParquetReader)HoodieIOFactory.getIOFactory((HoodieStorage)this.metaClient.getStorage()).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader((HoodieConfig)this.config, new StoragePath(this.metaClient.getArchivePath(), fileName));
                Throwable throwable = null;
                try {
                    ClosableIterator iterator = reader.getIndexedRecordIterator(HoodieLSMTimelineInstant.getClassSchema(), HoodieLSMTimelineInstant.getClassSchema());
                    Throwable throwable2 = null;
                    try {
                        while (iterator.hasNext()) {
                            IndexedRecord record = (IndexedRecord)iterator.next();
                            writer.write(record.get(0).toString(), (HoodieRecord)new HoodieAvroIndexedRecord(record), HoodieLSMTimelineInstant.getClassSchema());
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (iterator == null) continue;
                        if (throwable2 != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        iterator.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new HoodieCommitException("Failed to compact source files", e);
        }
    }

    public void clean(HoodieEngineContext context, int compactedVersions) throws IOException {
        List allSnapshotVersions = LSMTimeline.allSnapshotVersions((HoodieTableMetaClient)this.metaClient);
        int numVersionsToKeep = 3 + compactedVersions;
        if (allSnapshotVersions.size() > numVersionsToKeep) {
            allSnapshotVersions.sort((v1, v2) -> v2 - v1);
            List versionsToKeep = allSnapshotVersions.subList(0, numVersionsToKeep);
            Set filesToKeep = versionsToKeep.stream().flatMap(version -> LSMTimeline.latestSnapshotManifest((HoodieTableMetaClient)this.metaClient, (int)version).getFileNames().stream()).collect(Collectors.toSet());
            ArrayList manifestFilesToClean = new ArrayList();
            LSMTimeline.listAllManifestFiles((HoodieTableMetaClient)this.metaClient).forEach(fileStatus -> {
                if (!versionsToKeep.contains(LSMTimeline.getManifestVersion((String)fileStatus.getPath().getName()))) {
                    manifestFilesToClean.add(fileStatus.getPath().toString());
                }
            });
            HadoopFSUtils.deleteFilesParallelize((HoodieTableMetaClient)this.metaClient, manifestFilesToClean, (HoodieEngineContext)context, (int)this.config.getArchiveDeleteParallelism(), (boolean)false);
            List dataFilesToClean = LSMTimeline.listAllMetaFiles((HoodieTableMetaClient)this.metaClient).stream().filter(fileStatus -> !filesToKeep.contains(fileStatus.getPath().getName())).map(fileStatus -> fileStatus.getPath().toString()).collect(Collectors.toList());
            HadoopFSUtils.deleteFilesParallelize((HoodieTableMetaClient)this.metaClient, dataFilesToClean, (HoodieEngineContext)context, (int)this.config.getArchiveDeleteParallelism(), (boolean)false);
        }
    }

    private HoodieLSMTimelineManifest.LSMFileEntry getFileEntry(String fileName) throws IOException {
        long fileLen = this.metaClient.getStorage().getPathInfo(new StoragePath(this.metaClient.getArchivePath(), fileName)).getLength();
        return HoodieLSMTimelineManifest.LSMFileEntry.getInstance((String)fileName, (long)fileLen);
    }

    private List<String> getCandidateFiles(List<HoodieLSMTimelineManifest.LSMFileEntry> files, int filesBatch) throws IOException {
        ArrayList<String> candidates = new ArrayList<String>();
        long totalFileLen = 0L;
        for (int i = 0; i < filesBatch; ++i) {
            HoodieLSMTimelineManifest.LSMFileEntry fileEntry = files.get(i);
            if (totalFileLen > 1048576000L) {
                return candidates;
            }
            totalFileLen += fileEntry.getFileLen();
            candidates.add(fileEntry.getFileName());
        }
        return candidates;
    }

    private static String newFileName(String minInstant, String maxInstant, int layer) {
        return String.format("%s_%s_%d%s", minInstant, maxInstant, layer, HoodieFileFormat.PARQUET.getFileExtension());
    }

    @VisibleForTesting
    public static String compactedFileName(List<String> files) {
        String minInstant = files.stream().map(LSMTimeline::getMinInstantTime).min(Comparator.naturalOrder()).get();
        String maxInstant = files.stream().map(LSMTimeline::getMaxInstantTime).max(Comparator.naturalOrder()).get();
        int currentLayer = LSMTimeline.getFileLayer((String)files.get(0));
        return LSMTimelineWriter.newFileName(minInstant, maxInstant, currentLayer + 1);
    }

    private HoodieWriteConfig getOrCreateWriterConfig() {
        if (this.writeConfig == null) {
            this.writeConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)this.config.getProps()).withPopulateMetaFields(false).build();
        }
        return this.writeConfig;
    }

    private HoodieFileWriter openWriter(StoragePath filePath) {
        try {
            return HoodieFileWriterFactory.getFileWriter((String)"", (StoragePath)filePath, (HoodieStorage)this.metaClient.getStorage(), (HoodieConfig)this.getOrCreateWriterConfig(), (Schema)HoodieLSMTimelineInstant.getClassSchema(), (TaskContextSupplier)this.taskContextSupplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
        }
        catch (IOException e) {
            throw new HoodieException("Unable to initialize archiving writer", (Throwable)e);
        }
    }
}

