/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.bootstrap;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;

public abstract class HoodieBootstrapSchemaProvider {
    protected final HoodieWriteConfig writeConfig;

    public HoodieBootstrapSchemaProvider(HoodieWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
    }

    public final Schema getBootstrapSchema(HoodieEngineContext context, List<Pair<String, List<HoodieFileStatus>>> partitions) {
        if (this.writeConfig.getSchema() != null) {
            Schema userSchema = new Schema.Parser().parse(this.writeConfig.getSchema());
            if (!HoodieAvroUtils.getNullSchema().equals((Object)userSchema)) {
                return userSchema;
            }
        }
        return this.getBootstrapSourceSchema(context, partitions);
    }

    protected abstract Schema getBootstrapSourceSchema(HoodieEngineContext var1, List<Pair<String, List<HoodieFileStatus>>> var2);
}

