/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.repair;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.repair.RepairUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestRepairUtils {
    private static final Map<String, List<Pair<String, String>>> BASE_FILE_INFO = new HashMap<String, List<Pair<String, String>>>();
    private static final Map<String, List<Pair<String, String>>> LOG_FILE_INFO = new HashMap<String, List<Pair<String, String>>>();
    private final Map<String, Map<String, List<Pair<String, String>>>> instantInfoMap = new HashMap<String, Map<String, List<Pair<String, String>>>>();
    @TempDir
    public static java.nio.file.Path tempDir;
    private static String basePath;
    private static HoodieTableMetaClient metaClient;

    @BeforeAll
    static void initFileInfo() throws IOException {
        HoodieTestCommitGenerator.initCommitInfoForRepairTests(BASE_FILE_INFO, LOG_FILE_INFO);
        basePath = tempDir.toAbsolutePath().toString();
        metaClient = HoodieTestUtils.init((String)basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE);
    }

    public void setupTimelineInFS() throws IOException {
        HoodieTestCommitGenerator.setupTimelineInFS(basePath, BASE_FILE_INFO, LOG_FILE_INFO, this.instantInfoMap);
    }

    @Test
    public void testTagInstantsOfBaseAndLogFiles() {
        List expectedList;
        List fileNameList;
        String instantTime;
        HashMap<String, List> expectedResult = new HashMap<String, List>();
        ArrayList inputPathList = new ArrayList();
        for (Map.Entry<String, List<Pair<String, String>>> entry : BASE_FILE_INFO.entrySet()) {
            instantTime = entry.getKey();
            fileNameList = entry.getValue().stream().map(e -> {
                String partitionPath = (String)e.getKey();
                String fileId = (String)e.getValue();
                return new StoragePath(new StoragePath(partitionPath), HoodieTestCommitGenerator.getBaseFilename(instantTime, fileId)).toString();
            }).collect(Collectors.toList());
            expectedList = expectedResult.computeIfAbsent(instantTime, k -> new ArrayList());
            expectedList.addAll(fileNameList);
            inputPathList.addAll(fileNameList.stream().map(path -> new StoragePath(basePath, path)).collect(Collectors.toList()));
        }
        for (Map.Entry<String, List<Pair<String, String>>> entry : LOG_FILE_INFO.entrySet()) {
            instantTime = entry.getKey();
            fileNameList = entry.getValue().stream().map(e -> {
                String partitionPath = (String)e.getKey();
                String fileId = (String)e.getValue();
                return new StoragePath(new StoragePath(partitionPath), HoodieTestCommitGenerator.getLogFilename(instantTime, fileId)).toString();
            }).collect(Collectors.toList());
            expectedList = expectedResult.computeIfAbsent(instantTime, k -> new ArrayList());
            expectedList.addAll(fileNameList);
            inputPathList.addAll(fileNameList.stream().map(path -> new StoragePath(basePath, path)).collect(Collectors.toList()));
        }
        Assertions.assertEquals(expectedResult, (Object)RepairUtils.tagInstantsOfBaseAndLogFiles((String)basePath, inputPathList));
    }

    @Test
    public void testGetBaseAndLogFilePathsFromTimeline() throws IOException {
        this.setupTimelineInFS();
        HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
        HoodieInstant commitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001");
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", "005");
        HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "compaction", "006");
        Map<String, List<Pair<String, String>>> partitionToFileIdAndNameMap = this.instantInfoMap.get(commitInstant.getTimestamp());
        Set expectedPaths = partitionToFileIdAndNameMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(fileInfo -> new Path((String)entry.getKey(), (String)fileInfo.getValue()).toString()).collect(Collectors.toList()).stream()).collect(Collectors.toSet());
        Assertions.assertEquals((Object)Option.of(expectedPaths), (Object)RepairUtils.getBaseAndLogFilePathsFromTimeline((HoodieTimeline)timeline, (HoodieInstant)commitInstant));
        Assertions.assertThrows(HoodieException.class, () -> TestRepairUtils.lambda$testGetBaseAndLogFilePathsFromTimeline$8((HoodieTimeline)timeline, inflightInstant));
        Assertions.assertEquals((Object)Option.empty(), (Object)RepairUtils.getBaseAndLogFilePathsFromTimeline((HoodieTimeline)timeline, (HoodieInstant)compactionInstant));
    }

    @Test
    public void testFindInstantFilesToRemove() throws IOException {
        this.setupTimelineInFS();
        HoodieInstant existingInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001");
        Map<String, List<Pair<String, String>>> partitionToFileIdAndNameMap = this.instantInfoMap.get(existingInstant.getTimestamp());
        List fileListFromFs = partitionToFileIdAndNameMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(fileInfo -> new StoragePath((String)entry.getKey(), (String)fileInfo.getValue()).toString()).collect(Collectors.toList()).stream()).collect(Collectors.toList());
        String danglingFilePath = new StoragePath("2022/01/02", HoodieTestCommitGenerator.getBaseFilename(existingInstant.getTimestamp(), UUID.randomUUID().toString())).toString();
        fileListFromFs.add(danglingFilePath);
        Assertions.assertEquals((Object)CollectionUtils.createImmutableList((Object[])new String[]{danglingFilePath}), (Object)RepairUtils.findInstantFilesToRemove((String)existingInstant.getTimestamp(), fileListFromFs, (HoodieActiveTimeline)metaClient.getActiveTimeline(), (HoodieArchivedTimeline)metaClient.getArchivedTimeline()));
        Assertions.assertEquals(fileListFromFs, (Object)RepairUtils.findInstantFilesToRemove((String)"004", fileListFromFs, (HoodieActiveTimeline)metaClient.getActiveTimeline(), (HoodieArchivedTimeline)metaClient.getArchivedTimeline()));
    }

    private static /* synthetic */ void lambda$testGetBaseAndLogFilePathsFromTimeline$8(HoodieTimeline timeline, HoodieInstant inflightInstant) throws Throwable {
        RepairUtils.getBaseAndLogFilePathsFromTimeline((HoodieTimeline)timeline, (HoodieInstant)inflightInstant);
    }
}

