/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.action.index.AbstractIndexingCatchupTask;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestIndexingCatchupTask {
    @Mock
    private HoodieTableMetadataWriter metadataWriter;
    @Mock
    private HoodieTableMetaClient metaClient;
    @Mock
    private HoodieTableMetaClient metadataMetaClient;
    @Mock
    private TransactionManager transactionManager;
    @Mock
    private HoodieEngineContext engineContext;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testTaskSuccessful() {
        List<HoodieInstant> instants = Collections.singletonList(new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "001"));
        HashSet<String> metadataCompletedInstants = new HashSet<String>();
        DummyIndexingCatchupTask task = new DummyIndexingCatchupTask(this.metadataWriter, instants, metadataCompletedInstants, this.metaClient, this.metadataMetaClient, this.transactionManager, "001", this.engineContext);
        task.run();
        Assertions.assertEquals((Object)"001", (Object)task.currentCaughtupInstant);
    }

    @Test
    public void testTaskInterrupted() {
        HoodieInstant neverCompletedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "001");
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        HoodieActiveTimeline filteredTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        HoodieActiveTimeline furtherFilteredTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)this.metaClient.reloadActiveTimeline()).thenReturn((Object)activeTimeline);
        Mockito.when((Object)activeTimeline.filterCompletedInstants()).thenReturn((Object)filteredTimeline);
        Mockito.when((Object)filteredTimeline.filter((Predicate)ArgumentMatchers.any())).thenReturn((Object)furtherFilteredTimeline);
        AtomicInteger callCount = new AtomicInteger(0);
        Mockito.when((Object)furtherFilteredTimeline.firstInstant()).thenAnswer(invocation -> {
            if (callCount.incrementAndGet() > 3) {
                throw new InterruptedException("Simulated interruption");
            }
            return Option.empty();
        });
        DummyIndexingCatchupTask task = new DummyIndexingCatchupTask(this.metadataWriter, Collections.singletonList(neverCompletedInstant), new HashSet<String>(), this.metaClient, this.metadataMetaClient, this.transactionManager, "001", this.engineContext);
        CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                task.awaitInstantCaughtUp(neverCompletedInstant);
            }
            catch (HoodieIndexException e) {
                latch.countDown();
            }
        });
        thread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Should have thrown HoodieIndexException and not interrupted exception. This means latch count down was not called.");
        }
    }

    static class DummyIndexingCatchupTask
    extends AbstractIndexingCatchupTask {
        public DummyIndexingCatchupTask(HoodieTableMetadataWriter metadataWriter, List<HoodieInstant> instantsToIndex, Set<String> metadataCompletedInstants, HoodieTableMetaClient metaClient, HoodieTableMetaClient metadataMetaClient, TransactionManager transactionManager, String currentCaughtupInstant, HoodieEngineContext engineContext) {
            super(metadataWriter, instantsToIndex, metadataCompletedInstants, metaClient, metadataMetaClient, transactionManager, currentCaughtupInstant, engineContext);
        }

        public void run() {
        }

        public void updateIndexForWriteAction(HoodieInstant instant) {
        }
    }
}

