/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.CleanFileInfo;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestCleanPlanner {
    private static final StorageConfiguration<Configuration> CONF = HoodieTestUtils.getDefaultStorageConf();
    private final HoodieEngineContext context = new HoodieLocalEngineContext(CONF);
    private final HoodieTable<?, ?, ?, ?> mockHoodieTable = (HoodieTable)Mockito.mock(HoodieTable.class);
    private SyncableFileSystemView mockFsView;
    private static String PARTITION1 = "partition1";
    private static String PARTITION2 = "partition2";
    private static String PARTITION3 = "partition3";

    @BeforeEach
    void setUp() {
        this.mockFsView = (SyncableFileSystemView)Mockito.mock(SyncableFileSystemView.class);
        Mockito.when((Object)this.mockHoodieTable.getHoodieView()).thenReturn((Object)this.mockFsView);
        SyncableFileSystemView sliceView = (SyncableFileSystemView)Mockito.mock(SyncableFileSystemView.class);
        Mockito.when((Object)this.mockHoodieTable.getSliceView()).thenReturn((Object)sliceView);
        Mockito.when((Object)sliceView.getPendingCompactionOperations()).thenReturn(Stream.empty());
        Mockito.when((Object)sliceView.getPendingLogCompactionOperations()).thenReturn(Stream.empty());
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)this.mockHoodieTable.getMetaClient()).thenReturn((Object)metaClient);
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        HoodieTimeline mockCompletedCommitsTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)mockCompletedCommitsTimeline.countInstants()).thenReturn((Object)10);
        Mockito.when((Object)this.mockHoodieTable.getCompletedCommitsTimeline()).thenReturn((Object)mockCompletedCommitsTimeline);
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void testGetDeletePaths(HoodieWriteConfig config, String earliestInstant, List<HoodieFileGroup> allFileGroups, List<Pair<String, Option<byte[]>>> savepoints, List<HoodieFileGroup> replacedFileGroups, Pair<Boolean, List<CleanFileInfo>> expected) throws IOException {
        Set savepointTimestamps = savepoints.stream().map(Pair::getLeft).collect(Collectors.toSet());
        Mockito.when((Object)this.mockHoodieTable.getSavepointTimestamps()).thenReturn(savepointTimestamps);
        if (!savepoints.isEmpty()) {
            HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
            Mockito.when((Object)this.mockHoodieTable.getActiveTimeline()).thenReturn((Object)activeTimeline);
            for (Pair<String, Option<byte[]>> savepoint : savepoints) {
                HoodieInstant instant = new HoodieInstant(false, "savepoint", (String)savepoint.getLeft());
                Mockito.when((Object)activeTimeline.getInstantDetails(instant)).thenReturn(savepoint.getRight());
            }
        }
        String partitionPath = "partition1";
        if (config.getCleanerPolicy() == HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS) {
            Mockito.when((Object)this.mockFsView.getAllReplacedFileGroups(partitionPath)).thenReturn(replacedFileGroups.stream());
        } else {
            Mockito.when((Object)this.mockFsView.getReplacedFileGroupsBefore(earliestInstant, partitionPath)).thenReturn(replacedFileGroups.stream());
        }
        Mockito.when((Object)this.mockFsView.getAllFileGroupsStateless(partitionPath)).thenReturn(allFileGroups.stream());
        CleanPlanner cleanPlanner = new CleanPlanner(this.context, this.mockHoodieTable, config);
        HoodieInstant earliestCommitToRetain = new HoodieInstant(HoodieInstant.State.COMPLETED, "COMMIT", earliestInstant);
        Pair actual = cleanPlanner.getDeletePaths(partitionPath, Option.of((Object)earliestCommitToRetain));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"incrCleaningPartitionsTestCases"})
    void testPartitionsForIncrCleaning(boolean isPartitioned, HoodieWriteConfig config, String earliestInstant, String lastCompletedTimeInLastClean, String lastCleanInstant, String earliestInstantsInLastClean, List<String> partitionsInLastClean, Map<String, List<String>> savepointsTrackedInLastClean, Map<String, List<String>> activeInstantsPartitions, Map<String, List<String>> savepoints, List<String> expectedPartitions, boolean areCommitsForSavepointsRemoved) throws IOException {
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)this.mockHoodieTable.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Set savepointTimestamps = savepoints.keySet().stream().collect(Collectors.toSet());
        Mockito.when((Object)this.mockHoodieTable.getSavepointTimestamps()).thenReturn(savepointTimestamps);
        if (!savepoints.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : savepoints.entrySet()) {
                Pair<HoodieSavepointMetadata, Option<byte[]>> savepointMetadataOptionPair = TestCleanPlanner.getSavepointMetadata(entry.getValue());
                HoodieInstant instant = new HoodieInstant(false, "savepoint", entry.getKey());
                Mockito.when((Object)activeTimeline.getInstantDetails(instant)).thenReturn(savepointMetadataOptionPair.getRight());
            }
        }
        Pair<HoodieCleanMetadata, Option<byte[]>> cleanMetadataOptionPair = TestCleanPlanner.getCleanCommitMetadata(partitionsInLastClean, lastCleanInstant, earliestInstantsInLastClean, lastCompletedTimeInLastClean, savepointsTrackedInLastClean.keySet());
        TestCleanPlanner.mockLastCleanCommit(this.mockHoodieTable, lastCleanInstant, earliestInstantsInLastClean, activeTimeline, cleanMetadataOptionPair);
        TestCleanPlanner.mockFewActiveInstants(this.mockHoodieTable, activeInstantsPartitions, savepointsTrackedInLastClean, areCommitsForSavepointsRemoved);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        Mockito.when((Object)this.mockHoodieTable.getStorage()).thenReturn((Object)storage);
        HoodieTableMetadata hoodieTableMetadata = (HoodieTableMetadata)Mockito.mock(HoodieTableMetadata.class);
        Mockito.when((Object)this.mockHoodieTable.getMetadataTable()).thenReturn((Object)hoodieTableMetadata);
        Mockito.when((Object)hoodieTableMetadata.getAllPartitionPaths()).thenReturn(isPartitioned ? Arrays.asList(PARTITION1, PARTITION2, PARTITION3) : Collections.singletonList(""));
        CleanPlanner cleanPlanner = new CleanPlanner(this.context, this.mockHoodieTable, config);
        HoodieInstant earliestCommitToRetain = new HoodieInstant(HoodieInstant.State.COMPLETED, "COMMIT", earliestInstant);
        List partitionsToClean = cleanPlanner.getPartitionPathsToClean(Option.of((Object)earliestCommitToRetain));
        Collections.sort(expectedPartitions);
        Collections.sort(partitionsToClean);
        Assertions.assertEquals(expectedPartitions, (Object)partitionsToClean);
    }

    static Stream<Arguments> testCases() {
        return Stream.concat(TestCleanPlanner.keepLatestByHoursOrCommitsArgs(), TestCleanPlanner.keepLatestVersionsArgs());
    }

    static Stream<Arguments> incrCleaningPartitionsTestCases() {
        return TestCleanPlanner.keepLatestByHoursOrCommitsArgsIncrCleanPartitions();
    }

    static Stream<Arguments> keepLatestVersionsArgs() {
        HoodieWriteConfig keepLatestVersionsConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainFileVersions(2).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).build()).build();
        String instant1 = "20231205194919610";
        String instant2 = "20231204194919610";
        String instant3 = "20231201194919610";
        String instant4 = "20231127194919610";
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(instant2, instant1))), Collections.emptyList(), Collections.emptyList(), Pair.of((Object)false, Collections.emptyList())}));
        HoodieFileGroup fileGroup = TestCleanPlanner.buildFileGroup(Arrays.asList(instant4, instant3, instant2, instant1));
        String instant3Path = fileGroup.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(instant3)).findFirst().get().getPath();
        CleanFileInfo expectedCleanFileInfoForInstant3 = new CleanFileInfo(instant3Path, false);
        String instant4Path = fileGroup.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(instant4)).findFirst().get().getPath();
        CleanFileInfo expectedCleanFileInfoForInstant4 = new CleanFileInfo(instant4Path, false);
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(fileGroup), Collections.emptyList(), Collections.emptyList(), Pair.of((Object)false, Arrays.asList(expectedCleanFileInfoForInstant3, expectedCleanFileInfoForInstant4))}));
        List<Pair> savepoints = Collections.singletonList(Pair.of((Object)instant4, TestCleanPlanner.getSavepointBytes("partition1", Collections.singletonList(instant4Path))));
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(fileGroup), savepoints, Collections.emptyList(), Pair.of((Object)false, Arrays.asList(expectedCleanFileInfoForInstant3))}));
        HoodieFileGroup replacedFileGroup = TestCleanPlanner.buildFileGroup(Collections.singletonList(instant4));
        String replacedFilePath = ((HoodieBaseFile)replacedFileGroup.getAllBaseFiles().findFirst().get()).getPath();
        CleanFileInfo expectedReplaceCleanFileInfo = new CleanFileInfo(replacedFilePath, false);
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(instant2, instant1))), Collections.emptyList(), Collections.singletonList(replacedFileGroup), Pair.of((Object)false, Collections.singletonList(expectedReplaceCleanFileInfo))}));
        List<Pair> replacedFileGroupSavepoint = Collections.singletonList(Pair.of((Object)instant4, TestCleanPlanner.getSavepointBytes("partition1", Collections.singletonList(replacedFilePath))));
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(instant2, instant1))), replacedFileGroupSavepoint, Collections.singletonList(replacedFileGroup), Pair.of((Object)false, Collections.emptyList())}));
        return arguments.stream();
    }

    static Stream<Arguments> keepLatestByHoursOrCommitsArgs() {
        String earliestInstant = "20231204194919610";
        String earliestInstantPlusTwoDays = "20231205194919610";
        String earliestInstantMinusThreeDays = "20231201194919610";
        String earliestInstantMinusOneWeek = "20231127194919610";
        String earliestInstantMinusOneMonth = "20231104194919610";
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        HoodieFileGroup fileGroupsBeforeInstant = TestCleanPlanner.buildFileGroup(Arrays.asList(earliestInstantMinusOneMonth, earliestInstantMinusOneWeek));
        CleanFileInfo expectedCleanFileInfoForFirstFile = new CleanFileInfo(fileGroupsBeforeInstant.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(earliestInstantMinusOneMonth)).findFirst().get().getPath(), false);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(fileGroupsBeforeInstant), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.singletonList(expectedCleanFileInfoForFirstFile))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(earliestInstantMinusOneMonth, earliestInstantPlusTwoDays))), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        String oldestFileInstant = earliestInstantMinusOneMonth;
        HoodieFileGroup fileGroup = TestCleanPlanner.buildFileGroup(Arrays.asList(oldestFileInstant, earliestInstantMinusThreeDays, earliestInstantPlusTwoDays));
        String oldestFilePath = fileGroup.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(oldestFileInstant)).findFirst().get().getPath();
        CleanFileInfo expectedCleanFileInfo = new CleanFileInfo(oldestFilePath, false);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(fileGroup), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.singletonList(expectedCleanFileInfo))));
        List<Pair<String, Option<byte[]>>> savepoints = Collections.singletonList(Pair.of((Object)oldestFileInstant, TestCleanPlanner.getSavepointBytes("partition1", Collections.singletonList(oldestFilePath))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(fileGroup), savepoints, Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        HoodieFileGroup replacedFileGroup = TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth));
        String replacedFilePath = ((HoodieBaseFile)replacedFileGroup.getAllBaseFiles().findFirst().get()).getPath();
        CleanFileInfo expectedReplaceCleanFileInfo = new CleanFileInfo(replacedFilePath, false);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), Collections.emptyList(), Collections.singletonList(replacedFileGroup), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.singletonList(expectedReplaceCleanFileInfo))));
        List<Pair<String, Option<byte[]>>> savepointsForReplacedGroup = Collections.singletonList(Pair.of((Object)oldestFileInstant, TestCleanPlanner.getSavepointBytes("partition1", Collections.singletonList(replacedFilePath))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), savepointsForReplacedGroup, Collections.singletonList(replacedFileGroup), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        HoodieWriteConfig writeConfigWithLargerRetention = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(50).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).build()).build();
        arguments.add(Arguments.of((Object[])new Object[]{writeConfigWithLargerRetention, earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), Collections.emptyList(), Collections.singletonList(replacedFileGroup), Pair.of((Object)false, Collections.emptyList())}));
        return arguments.stream();
    }

    static Stream<Arguments> keepLatestByHoursOrCommitsArgsIncrCleanPartitions() {
        String earliestInstantMinusOneMonth;
        String earliestInstantMinusOneWeek;
        String earliestInstantMinusSixDays;
        String earliestInstantPlusTwoDays;
        String earliestInstant = "20231204194919610";
        String lastCleanInstant = earliestInstantPlusTwoDays = "20231206194919610";
        String earliestInstantMinusThreeDays = "20231201194919610";
        String earliestInstantMinusFourDays = "20231130194919610";
        String earliestInstantMinusFiveDays = "20231129194919610";
        String earliestInstantInLastClean = earliestInstantMinusSixDays = "20231128194919610";
        String lastCompletedInLastClean = earliestInstantMinusSixDays;
        String savepoint2 = earliestInstantMinusOneWeek = "20231127194919610";
        String savepoint3 = earliestInstantMinusOneMonth = "20231104194919610";
        List<String> threePartitionsInActiveTimeline = Arrays.asList(PARTITION1, PARTITION2, PARTITION3);
        HashMap<String, List<String>> activeInstantsPartitionsMap3 = new HashMap<String, List<String>>();
        activeInstantsPartitionsMap3.put(earliestInstantMinusThreeDays, threePartitionsInActiveTimeline);
        activeInstantsPartitionsMap3.put(earliestInstantMinusFourDays, threePartitionsInActiveTimeline);
        activeInstantsPartitionsMap3.put(earliestInstantMinusFiveDays, threePartitionsInActiveTimeline);
        List<String> twoPartitionsInActiveTimeline = Arrays.asList(PARTITION2, PARTITION3);
        HashMap<String, List<String>> activeInstantsPartitionsMap2 = new HashMap<String, List<String>>();
        activeInstantsPartitionsMap2.put(earliestInstantMinusThreeDays, twoPartitionsInActiveTimeline);
        activeInstantsPartitionsMap2.put(earliestInstantMinusFourDays, twoPartitionsInActiveTimeline);
        activeInstantsPartitionsMap2.put(earliestInstantMinusFiveDays, twoPartitionsInActiveTimeline);
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.emptyMap(), activeInstantsPartitionsMap3, Collections.emptyMap(), threePartitionsInActiveTimeline, false));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.emptyMap(), activeInstantsPartitionsMap3, Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), threePartitionsInActiveTimeline, false));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), activeInstantsPartitionsMap2, Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), twoPartitionsInActiveTimeline, false));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), activeInstantsPartitionsMap2, Collections.emptyMap(), threePartitionsInActiveTimeline, false));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), activeInstantsPartitionsMap2, Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), twoPartitionsInActiveTimeline, false));
        HashMap<String, List<String>> latestSavepoints = new HashMap<String, List<String>>();
        latestSavepoints.put(savepoint2, Collections.singletonList(PARTITION1));
        latestSavepoints.put(savepoint3, Collections.singletonList(PARTITION1));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), activeInstantsPartitionsMap2, latestSavepoints, twoPartitionsInActiveTimeline, false));
        HashMap<String, List<String>> previousSavepoints = new HashMap<String, List<String>>();
        previousSavepoints.put(savepoint2, Collections.singletonList(PARTITION1));
        previousSavepoints.put(savepoint3, Collections.singletonList(PARTITION2));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), previousSavepoints, activeInstantsPartitionsMap2, Collections.singletonMap(savepoint3, Collections.singletonList(PARTITION2)), threePartitionsInActiveTimeline, false));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), previousSavepoints, activeInstantsPartitionsMap3, Collections.singletonMap(savepoint3, Collections.singletonList(PARTITION2)), threePartitionsInActiveTimeline, false));
        List<String> unPartitionsInActiveTimeline = Arrays.asList("");
        HashMap<String, List<String>> activeInstantsUnPartitionsMap = new HashMap<String, List<String>>();
        activeInstantsUnPartitionsMap.put(earliestInstantMinusThreeDays, unPartitionsInActiveTimeline);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(false, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(""), Collections.singletonMap(savepoint2, Collections.singletonList("")), activeInstantsUnPartitionsMap, Collections.emptyMap(), unPartitionsInActiveTimeline, false));
        activeInstantsPartitionsMap2.remove(earliestInstantMinusOneWeek);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), activeInstantsPartitionsMap2, Collections.emptyMap(), threePartitionsInActiveTimeline, true));
        return arguments.stream();
    }

    private static HoodieWriteConfig getCleanByHoursConfig() {
        return HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().cleanerNumHoursRetained(24).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS).build()).build();
    }

    private static HoodieWriteConfig getCleanByCommitsConfig() {
        return HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(5).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).build()).build();
    }

    private static List<Arguments> buildArgumentsForCleanByHoursAndCommitsCases(String earliestInstant, List<HoodieFileGroup> allFileGroups, List<Pair<String, Option<byte[]>>> savepoints, List<HoodieFileGroup> replacedFileGroups, Pair<Boolean, List<CleanFileInfo>> expected) {
        return Arrays.asList(Arguments.of((Object[])new Object[]{TestCleanPlanner.getCleanByHoursConfig(), earliestInstant, allFileGroups, savepoints, replacedFileGroups, expected}), Arguments.of((Object[])new Object[]{TestCleanPlanner.getCleanByCommitsConfig(), earliestInstant, allFileGroups, savepoints, replacedFileGroups, expected}));
    }

    private static List<Arguments> buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(boolean isPartitioned, String earliestInstant, String latestCompletedInLastClean, String lastKnownCleanInstantTime, String earliestInstantInLastClean, List<String> partitionsInLastClean, Map<String, List<String>> savepointsTrackedInLastClean, Map<String, List<String>> activeInstantsToPartitionsMap, Map<String, List<String>> savepoints, List<String> expectedPartitions, boolean areCommitsForSavepointsRemoved) {
        return Arrays.asList(Arguments.of((Object[])new Object[]{isPartitioned, TestCleanPlanner.getCleanByHoursConfig(), earliestInstant, latestCompletedInLastClean, lastKnownCleanInstantTime, earliestInstantInLastClean, partitionsInLastClean, savepointsTrackedInLastClean, activeInstantsToPartitionsMap, savepoints, expectedPartitions, areCommitsForSavepointsRemoved}), Arguments.of((Object[])new Object[]{isPartitioned, TestCleanPlanner.getCleanByCommitsConfig(), earliestInstant, latestCompletedInLastClean, lastKnownCleanInstantTime, earliestInstantInLastClean, partitionsInLastClean, savepointsTrackedInLastClean, activeInstantsToPartitionsMap, savepoints, expectedPartitions, areCommitsForSavepointsRemoved}));
    }

    private static HoodieFileGroup buildFileGroup(List<String> baseFileCommitTimes) {
        return TestCleanPlanner.buildFileGroup(baseFileCommitTimes, PARTITION1);
    }

    private static HoodieFileGroup buildFileGroup(List<String> baseFileCommitTimes, String partition) {
        String fileGroup = UUID.randomUUID() + "-0";
        HoodieFileGroupId fileGroupId = new HoodieFileGroupId(partition, UUID.randomUUID().toString());
        HoodieTimeline timeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)timeline.lastInstant()).thenReturn((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "COMMIT", baseFileCommitTimes.get(baseFileCommitTimes.size() - 1))));
        HoodieFileGroup group = new HoodieFileGroup(fileGroupId, timeline);
        for (String baseFileCommitTime : baseFileCommitTimes) {
            Mockito.when((Object)timeline.containsOrBeforeTimelineStarts(baseFileCommitTime)).thenReturn((Object)true);
            HoodieBaseFile baseFile = new HoodieBaseFile(String.format("file:///tmp/base/%s_1-0-1_%s.parquet", fileGroup, baseFileCommitTime));
            group.addBaseFile(baseFile);
        }
        return group;
    }

    private static Option<byte[]> getSavepointBytes(String partition, List<String> paths) {
        try {
            HashMap<String, HoodieSavepointPartitionMetadata> partitionMetadata = new HashMap<String, HoodieSavepointPartitionMetadata>();
            List fileNames = paths.stream().map(path -> path.substring(path.lastIndexOf("/") + 1)).collect(Collectors.toList());
            partitionMetadata.put(partition, new HoodieSavepointPartitionMetadata(partition, fileNames));
            HoodieSavepointMetadata savepointMetadata = new HoodieSavepointMetadata("user", Long.valueOf(1L), "comments", partitionMetadata, Integer.valueOf(1));
            return TimelineMetadataUtils.serializeSavepointMetadata((HoodieSavepointMetadata)savepointMetadata);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Pair<HoodieCleanMetadata, Option<byte[]>> getCleanCommitMetadata(List<String> partitions, String instantTime, String earliestCommitToRetain, String lastCompletedTime, Set<String> savepointsToTrack) {
        try {
            HashMap partitionMetadata = new HashMap();
            partitions.forEach(partition -> partitionMetadata.put(partition, new HoodieCleanPartitionMetadata(partition, HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Boolean.valueOf(false))));
            HashMap<String, String> extraMetadata = new HashMap<String, String>();
            if (!savepointsToTrack.isEmpty()) {
                extraMetadata.put("savepointed_timestamps", savepointsToTrack.stream().collect(Collectors.joining(",")));
            }
            HoodieCleanMetadata cleanMetadata = new HoodieCleanMetadata(instantTime, Long.valueOf(100L), Integer.valueOf(10), earliestCommitToRetain, lastCompletedTime, partitionMetadata, CleanerUtils.CLEAN_METADATA_VERSION_2, Collections.EMPTY_MAP, extraMetadata.isEmpty() ? null : extraMetadata);
            return Pair.of((Object)cleanMetadata, (Object)TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)cleanMetadata));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Pair<HoodieSavepointMetadata, Option<byte[]>> getSavepointMetadata(List<String> partitions) {
        try {
            HashMap partitionMetadata = new HashMap();
            partitions.forEach(partition -> partitionMetadata.put(partition, new HoodieSavepointPartitionMetadata(partition, Collections.emptyList())));
            HoodieSavepointMetadata savepointMetadata = new HoodieSavepointMetadata("user", Long.valueOf(1L), "comments", partitionMetadata, Integer.valueOf(1));
            return Pair.of((Object)savepointMetadata, (Object)TimelineMetadataUtils.serializeSavepointMetadata((HoodieSavepointMetadata)savepointMetadata));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void mockLastCleanCommit(HoodieTable hoodieTable, String timestamp, String earliestCommitToRetain, HoodieActiveTimeline activeTimeline, Pair<HoodieCleanMetadata, Option<byte[]>> cleanMetadata) throws IOException {
        HoodieDefaultTimeline cleanTimeline = (HoodieDefaultTimeline)Mockito.mock(HoodieDefaultTimeline.class);
        Mockito.when((Object)activeTimeline.getCleanerTimeline()).thenReturn((Object)cleanTimeline);
        Mockito.when((Object)hoodieTable.getCleanTimeline()).thenReturn((Object)cleanTimeline);
        HoodieDefaultTimeline completedCleanTimeline = (HoodieDefaultTimeline)Mockito.mock(HoodieDefaultTimeline.class);
        Mockito.when((Object)cleanTimeline.filterCompletedInstants()).thenReturn((Object)completedCleanTimeline);
        HoodieInstant latestCleanInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", timestamp);
        Mockito.when((Object)completedCleanTimeline.lastInstant()).thenReturn((Object)Option.of((Object)latestCleanInstant));
        Mockito.when((Object)activeTimeline.isEmpty(latestCleanInstant)).thenReturn((Object)false);
        Mockito.when((Object)activeTimeline.getInstantDetails(latestCleanInstant)).thenReturn(cleanMetadata.getRight());
        HoodieDefaultTimeline commitsTimeline = (HoodieDefaultTimeline)Mockito.mock(HoodieDefaultTimeline.class);
        Mockito.when((Object)activeTimeline.getCommitsTimeline()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)commitsTimeline.isBeforeTimelineStarts(earliestCommitToRetain)).thenReturn((Object)false);
        Mockito.when((Object)hoodieTable.isPartitioned()).thenReturn((Object)true);
        Mockito.when((Object)hoodieTable.isMetadataTable()).thenReturn((Object)false);
    }

    private static void mockFewActiveInstants(HoodieTable hoodieTable, Map<String, List<String>> activeInstantsToPartitions, Map<String, List<String>> savepointedCommitsToAdd, boolean areCommitsForSavepointsRemoved) throws IOException {
        HoodieDefaultTimeline commitsTimeline = new HoodieDefaultTimeline();
        ArrayList instants = new ArrayList();
        HashMap<String, List> instantstoProcess = new HashMap<String, List>();
        instantstoProcess.putAll(activeInstantsToPartitions);
        if (!areCommitsForSavepointsRemoved) {
            instantstoProcess.putAll(savepointedCommitsToAdd);
        }
        instantstoProcess.forEach((k, v) -> {
            HoodieInstant hoodieInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", k);
            instants.add(hoodieInstant);
            HashMap partitionToWriteStats = new HashMap();
            v.forEach(partition -> partitionToWriteStats.put(partition, Collections.emptyList()));
            HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
            v.forEach(partition -> commitMetadata.getPartitionToWriteStats().put(partition, Collections.emptyList()));
            try {
                Mockito.when((Object)hoodieTable.getActiveTimeline().getInstantDetails(hoodieInstant)).thenReturn((Object)TimelineMetadataUtils.serializeCommitMetadata((HoodieCommitMetadata)commitMetadata));
            }
            catch (IOException e) {
                throw new RuntimeException("Should not have failed", e);
            }
        });
        commitsTimeline.setInstants(instants);
        Mockito.when((Object)hoodieTable.getCompletedCommitsTimeline()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)hoodieTable.isPartitioned()).thenReturn((Object)true);
        Mockito.when((Object)hoodieTable.isMetadataTable()).thenReturn((Object)false);
    }
}

