/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.util.Collections;
import java.util.HashMap;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHoodieIndexUtils {
    @Test
    public void testGetFunctionalIndexPath() {
        MetadataPartitionType partitionType = MetadataPartitionType.FUNCTIONAL_INDEX;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        String indexName = "testIndex";
        HashMap<String, HoodieIndexDefinition> indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
        indexDefinitions.put(indexName, new HoodieIndexDefinition("func_index_testIndex", "column_stats", "lower", Collections.singletonList("name"), null));
        HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata(indexDefinitions);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
        String result = HoodieIndexUtils.getPartitionNameFromPartitionType((MetadataPartitionType)partitionType, (HoodieTableMetaClient)metaClient, (String)indexName);
        Assertions.assertEquals((Object)"func_index_testIndex", (Object)result);
    }

    @Test
    public void testGetNonFunctionalIndexPath() {
        MetadataPartitionType partitionType = MetadataPartitionType.COLUMN_STATS;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        String result = HoodieIndexUtils.getPartitionNameFromPartitionType((MetadataPartitionType)partitionType, (HoodieTableMetaClient)metaClient, null);
        Assertions.assertEquals((Object)partitionType.getPartitionPath(), (Object)result);
    }

    @Test
    public void testExceptionForMissingFunctionalIndexMetadata() {
        MetadataPartitionType partitionType = MetadataPartitionType.FUNCTIONAL_INDEX;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexUtils.getPartitionNameFromPartitionType((MetadataPartitionType)partitionType, (HoodieTableMetaClient)metaClient, (String)"testIndex"));
    }
}

