/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;

public class HoodieMetadataTestTable
extends HoodieTestTable {
    private final HoodieTableMetadataWriter writer;

    protected HoodieMetadataTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient, HoodieTableMetadataWriter writer, Option<HoodieEngineContext> context) {
        super(basePath, storage, metaClient, context);
        this.writer = writer;
    }

    public static HoodieTestTable of(HoodieTableMetaClient metaClient) {
        return HoodieMetadataTestTable.of(metaClient, null, (Option<HoodieEngineContext>)Option.empty());
    }

    public static HoodieTestTable of(HoodieTableMetaClient metaClient, HoodieTableMetadataWriter writer, Option<HoodieEngineContext> context) {
        testTableState = HoodieTestTable.HoodieTestTableState.of();
        return new HoodieMetadataTestTable(metaClient.getBasePath().toString(), metaClient.getRawHoodieStorage(), metaClient, writer, context);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap, boolean bootstrap, boolean createInflightCommit) throws Exception {
        HoodieCommitMetadata commitMetadata = super.doWriteOperation(commitTime, operationType, newPartitionsToAdd, partitionToFilesNameLengthMap, bootstrap, true);
        if (this.writer != null && !createInflightCommit) {
            this.writer.performTableServices(Option.of((Object)commitTime));
            this.writer.updateFromWriteStatuses(commitMetadata, ((HoodieEngineContext)this.context.get()).emptyHoodieData(), commitTime);
        }
        if (!createInflightCommit) {
            if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
                FileCreateUtils.createCommit((String)this.basePath, (String)commitTime, (Option)Option.of((Object)commitMetadata));
            } else {
                FileCreateUtils.createDeltaCommit((String)this.basePath, (String)commitTime, (HoodieCommitMetadata)commitMetadata);
            }
            this.inflightCommits().remove(commitTime);
        }
        return commitMetadata;
    }

    public HoodieTestTable moveInflightCommitToComplete(String instantTime, HoodieCommitMetadata metadata) throws IOException {
        super.moveInflightCommitToComplete(instantTime, metadata);
        if (this.writer != null) {
            this.writer.updateFromWriteStatuses(metadata, ((HoodieEngineContext)this.context.get()).emptyHoodieData(), instantTime);
        }
        return this;
    }

    public HoodieTestTable moveInflightCompactionToComplete(String instantTime, HoodieCommitMetadata metadata) throws IOException {
        super.moveInflightCompactionToComplete(instantTime, metadata);
        if (this.writer != null) {
            this.writer.updateFromWriteStatuses(metadata, ((HoodieEngineContext)this.context.get()).emptyHoodieData(), instantTime);
        }
        return this;
    }

    public HoodieCleanMetadata doClean(String commitTime, Map<String, Integer> partitionFileCountsToDelete) throws IOException {
        HoodieCleanMetadata cleanMetadata = super.doClean(commitTime, partitionFileCountsToDelete);
        if (this.writer != null) {
            this.writer.update(cleanMetadata, commitTime);
        }
        return cleanMetadata;
    }

    public void repeatClean(String cleanCommitTime, HoodieCleanerPlan cleanerPlan, HoodieCleanMetadata cleanMetadata) throws IOException {
        super.repeatClean(cleanCommitTime, cleanerPlan, cleanMetadata);
        if (this.writer != null) {
            this.writer.update(cleanMetadata, cleanCommitTime);
        }
    }

    public HoodieTestTable addCompaction(String instantTime, HoodieCommitMetadata commitMetadata) throws Exception {
        super.addCompaction(instantTime, commitMetadata);
        if (this.writer != null) {
            this.writer.updateFromWriteStatuses(commitMetadata, ((HoodieEngineContext)this.context.get()).emptyHoodieData(), instantTime);
        }
        return this;
    }

    public HoodieTestTable addRollback(String instantTime, HoodieRollbackMetadata rollbackMetadata, HoodieRollbackPlan rollbackPlan) throws IOException {
        super.addRollback(instantTime, rollbackMetadata, rollbackPlan);
        if (this.writer != null) {
            this.writer.update(rollbackMetadata, instantTime);
        }
        return this;
    }

    public HoodieTestTable addRestore(String instantTime, HoodieRestoreMetadata restoreMetadata) throws IOException {
        super.addRestore(instantTime, restoreMetadata);
        if (this.writer != null) {
            this.writer.update(restoreMetadata, instantTime);
        }
        return this;
    }

    public HoodieTestTable addReplaceCommit(String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata, Option<HoodieCommitMetadata> inflightReplaceMetadata, HoodieReplaceCommitMetadata completeReplaceMetadata) throws Exception {
        super.addReplaceCommit(instantTime, requestedReplaceMetadata, inflightReplaceMetadata, completeReplaceMetadata);
        if (this.writer != null) {
            this.writer.updateFromWriteStatuses((HoodieCommitMetadata)completeReplaceMetadata, ((HoodieEngineContext)this.context.get()).emptyHoodieData(), instantTime);
        }
        return this;
    }
}

