/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.client.utils.LegacyArchivedMetaEntryReader;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLegacyArchivedMetaEntryReader {
    private static final Logger LOG = LoggerFactory.getLogger(TestLegacyArchivedMetaEntryReader.class);
    @TempDir
    File tempFile;

    @Test
    void testReadLegacyArchivedTimeline() throws Exception {
        String tableName = "testTable";
        String tablePath = this.tempFile.getAbsolutePath() + "/" + tableName;
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)tablePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)tableName);
        this.prepareLegacyArchivedTimeline(metaClient);
        LegacyArchivedMetaEntryReader reader = new LegacyArchivedMetaEntryReader(metaClient);
        ClosableIterator iterator = reader.getActiveActionsIterator();
        ArrayList<Object> activeActions = new ArrayList<Object>();
        while (iterator.hasNext()) {
            activeActions.add(iterator.next());
        }
        MatcherAssert.assertThat((Object)activeActions.stream().map(ActiveAction::getInstantTime).sorted().collect(Collectors.joining(",")), (Matcher)CoreMatchers.is((Object)"00000001,00000002,00000003,00000004,00000005,00000006,00000007,00000008,00000009,00000010"));
    }

    private void prepareLegacyArchivedTimeline(HoodieTableMetaClient metaClient) throws Exception {
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient);
        for (int i = 1; i < 11; ++i) {
            String instantTime = String.format("%08d", i);
            HoodieCommitMetadata metadata = testTable.createCommitMetadata(instantTime, WriteOperationType.INSERT, Arrays.asList("par1", "par2"), 10, false);
            testTable.addCommit(instantTime, Option.of((Object)metadata));
        }
        List instants = new HoodieActiveTimeline(metaClient, false).getInstantsAsStream().sorted().collect(Collectors.toList());
        this.archive(metaClient, instants.subList(0, instants.size() / 2));
        this.archive(metaClient, instants.subList(instants.size() / 2, instants.size()));
    }

    private HoodieLogFormat.Writer openWriter(HoodieTableMetaClient metaClient) {
        try {
            return HoodieLogFormat.newWriterBuilder().onParentPath(new StoragePath(metaClient.getArchivePath())).withFileId("commits").withFileExtension(".archive").withStorage(metaClient.getStorage()).withDeltaCommit("").build();
        }
        catch (IOException e) {
            throw new HoodieException("Unable to initialize HoodieLogFormat writer", (Throwable)e);
        }
    }

    public void archive(HoodieTableMetaClient metaClient, List<HoodieInstant> instants) throws HoodieCommitException {
        try (HoodieLogFormat.Writer writer = this.openWriter(metaClient);){
            Schema wrapperSchema = HoodieArchivedMetaEntry.getClassSchema();
            LOG.info("Wrapper schema " + wrapperSchema.toString());
            ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
            for (HoodieInstant hoodieInstant : instants) {
                try {
                    records.add(this.convertToAvroRecord(hoodieInstant, metaClient));
                }
                catch (Exception e) {
                    LOG.error("Failed to archive commits, .commit file: " + hoodieInstant.getFileName(), (Throwable)e);
                    throw e;
                }
            }
            this.writeToFile(metaClient, wrapperSchema, records, writer);
        }
        catch (Exception e) {
            throw new HoodieCommitException("Failed to archive commits", (Throwable)e);
        }
    }

    private void writeToFile(HoodieTableMetaClient metaClient, Schema wrapperSchema, List<IndexedRecord> records, HoodieLogFormat.Writer writer) throws Exception {
        if (records.size() > 0) {
            HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
            header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, wrapperSchema.toString());
            String keyField = metaClient.getTableConfig().getRecordKeyFieldProp();
            List indexRecords = records.stream().map(HoodieAvroIndexedRecord::new).collect(Collectors.toList());
            HoodieAvroDataBlock block = new HoodieAvroDataBlock(indexRecords, false, header, keyField);
            writer.appendBlock((HoodieLogBlock)block);
            records.clear();
        }
    }

    private IndexedRecord convertToAvroRecord(HoodieInstant hoodieInstant, HoodieTableMetaClient metaClient) throws IOException {
        return MetadataConversionUtils.createMetaWrapper((HoodieInstant)hoodieInstant, (HoodieTableMetaClient)metaClient);
    }
}

