/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hudi.client.transaction.InProcessLockProviderWithRuntimeError;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class TestTransactionManager
extends HoodieCommonTestHarness {
    HoodieWriteConfig writeConfig;
    TransactionManager transactionManager;

    @BeforeEach
    private void init(TestInfo testInfo) throws IOException {
        this.initPath();
        this.initMetaClient();
        this.writeConfig = this.getWriteConfig(testInfo.getTags().contains("useLockProviderWithRuntimeError"));
        this.transactionManager = new TransactionManager(this.writeConfig, this.metaClient.getStorage());
    }

    private HoodieWriteConfig getWriteConfig(boolean useLockProviderWithRuntimeError) {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(useLockProviderWithRuntimeError ? InProcessLockProviderWithRuntimeError.class : InProcessLockProvider.class).withLockWaitTimeInMillis(Long.valueOf(50L)).withNumRetries(2).withRetryWaitTimeInMillis(Long.valueOf(10L)).withClientNumRetries(2).withClientRetryWaitTimeInMillis(Long.valueOf(10L)).build()).forTable("testtable").withMetricsConfig(HoodieMetricsConfig.newBuilder().withReporterType(MetricsReporterType.INMEMORY.toString()).withLockingMetrics(true).on(true).build()).build();
    }

    @Test
    public void testSingleWriterTransaction() {
        Option<HoodieInstant> lastCompletedInstant = this.getInstant("0000001");
        Option<HoodieInstant> newTxnOwnerInstant = this.getInstant("0000002");
        this.transactionManager.beginTransaction(newTxnOwnerInstant, lastCompletedInstant);
        this.transactionManager.endTransaction(newTxnOwnerInstant);
    }

    @Test
    public void testSingleWriterNestedTransaction() {
        Option<HoodieInstant> lastCompletedInstant = this.getInstant("0000001");
        Option<HoodieInstant> newTxnOwnerInstant = this.getInstant("0000002");
        this.transactionManager.beginTransaction(newTxnOwnerInstant, lastCompletedInstant);
        Option<HoodieInstant> lastCompletedInstant1 = this.getInstant("0000003");
        Option<HoodieInstant> newTxnOwnerInstant1 = this.getInstant("0000004");
        Assertions.assertThrows(HoodieLockException.class, () -> this.transactionManager.beginTransaction(newTxnOwnerInstant1, lastCompletedInstant1));
        this.transactionManager.endTransaction(newTxnOwnerInstant);
        Assertions.assertDoesNotThrow(() -> this.transactionManager.endTransaction(newTxnOwnerInstant1));
    }

    @Test
    public void testMultiWriterTransactions() {
        int threadCount = 3;
        long awaitMaxTimeoutMs = 2000L;
        CountDownLatch latch = new CountDownLatch(3);
        AtomicBoolean writer1Completed = new AtomicBoolean(false);
        AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Option<HoodieInstant> lastCompletedInstant1 = this.getInstant("0000001");
        Option<HoodieInstant> newTxnOwnerInstant1 = this.getInstant("0000002");
        Option<HoodieInstant> lastCompletedInstant2 = this.getInstant("0000003");
        Option<HoodieInstant> newTxnOwnerInstant2 = this.getInstant("0000004");
        Thread writer1 = new Thread(() -> {
            Assertions.assertDoesNotThrow(() -> this.transactionManager.beginTransaction(newTxnOwnerInstant1, lastCompletedInstant1));
            latch.countDown();
            try {
                latch.await(2000L, TimeUnit.MILLISECONDS);
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertDoesNotThrow(() -> this.transactionManager.endTransaction(newTxnOwnerInstant1));
            writer1Completed.set(true);
        });
        writer1.start();
        Thread writer2 = new Thread(() -> {
            latch.countDown();
            try {
                latch.await(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertDoesNotThrow(() -> this.transactionManager.beginTransaction(newTxnOwnerInstant2, lastCompletedInstant2));
            Assertions.assertDoesNotThrow(() -> this.transactionManager.endTransaction(newTxnOwnerInstant2));
            writer2Completed.set(true);
        });
        writer2.start();
        latch.countDown();
        try {
            writer1.join();
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer1Completed.get());
        Assertions.assertTrue((boolean)writer2Completed.get());
    }

    @Test
    public void testEndTransactionByDiffOwner() throws InterruptedException {
        Option<HoodieInstant> lastCompletedInstant = this.getInstant("0000001");
        Option<HoodieInstant> newTxnOwnerInstant = this.getInstant("0000002");
        this.transactionManager.beginTransaction(newTxnOwnerInstant, lastCompletedInstant);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread writer2 = new Thread(() -> {
            Option<HoodieInstant> newTxnOwnerInstant1 = this.getInstant("0000003");
            this.transactionManager.endTransaction(newTxnOwnerInstant1);
            countDownLatch.countDown();
        });
        writer2.start();
        countDownLatch.await(30L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertTrue((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
        this.transactionManager.endTransaction(newTxnOwnerInstant);
        Assertions.assertFalse((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertFalse((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
    }

    @Test
    public void testTransactionsWithInstantTime() {
        Option<HoodieInstant> lastCompletedInstant = this.getInstant("0000001");
        Option<HoodieInstant> newTxnOwnerInstant = this.getInstant("0000002");
        this.transactionManager.beginTransaction(newTxnOwnerInstant, lastCompletedInstant);
        Assertions.assertTrue((this.transactionManager.getCurrentTransactionOwner() == newTxnOwnerInstant ? 1 : 0) != 0);
        Assertions.assertTrue((this.transactionManager.getLastCompletedTransactionOwner() == lastCompletedInstant ? 1 : 0) != 0);
        this.transactionManager.endTransaction(newTxnOwnerInstant);
        Assertions.assertFalse((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertFalse((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
        lastCompletedInstant = this.getInstant("0000002");
        newTxnOwnerInstant = this.getInstant("0000003");
        this.transactionManager.beginTransaction(newTxnOwnerInstant, lastCompletedInstant);
        this.transactionManager.endTransaction(this.getInstant("0000004"));
        Assertions.assertTrue((this.transactionManager.getCurrentTransactionOwner() == newTxnOwnerInstant ? 1 : 0) != 0);
        Assertions.assertTrue((this.transactionManager.getLastCompletedTransactionOwner() == lastCompletedInstant ? 1 : 0) != 0);
        this.transactionManager.endTransaction(newTxnOwnerInstant);
        lastCompletedInstant = this.getInstant("0000003");
        newTxnOwnerInstant = this.getInstant("0000004");
        this.transactionManager.beginTransaction(newTxnOwnerInstant, lastCompletedInstant);
        Assertions.assertTrue((this.transactionManager.getCurrentTransactionOwner() == newTxnOwnerInstant ? 1 : 0) != 0);
        Assertions.assertTrue((this.transactionManager.getLastCompletedTransactionOwner() == lastCompletedInstant ? 1 : 0) != 0);
        this.transactionManager.endTransaction(newTxnOwnerInstant);
        Assertions.assertFalse((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertFalse((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
        this.transactionManager.beginTransaction(this.getInstant("0000005"), Option.empty());
        Assertions.assertTrue((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertFalse((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
        this.transactionManager.endTransaction(this.getInstant("0000005"));
        Assertions.assertFalse((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertFalse((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
        this.transactionManager.beginTransaction(Option.empty(), Option.empty());
        Assertions.assertFalse((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertFalse((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
        this.transactionManager.endTransaction(Option.empty());
        Assertions.assertFalse((boolean)this.transactionManager.getCurrentTransactionOwner().isPresent());
        Assertions.assertFalse((boolean)this.transactionManager.getLastCompletedTransactionOwner().isPresent());
    }

    @Test
    @Tag(value="useLockProviderWithRuntimeError")
    public void testTransactionsWithUncheckedLockProviderRuntimeException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            try {
                this.transactionManager.beginTransaction(Option.empty(), Option.empty());
            }
            finally {
                this.transactionManager.endTransaction(Option.empty());
            }
        });
    }

    private Option<HoodieInstant> getInstant(String timestamp) {
        return Option.of((Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", timestamp));
    }
}

