/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.timeline;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.DummyActiveAction;
import org.apache.hudi.client.timeline.LSMTimelineWriter;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class TestCompletionTimeQueryView {
    @TempDir
    File tempFile;

    @Test
    void testReadCompletionTime() throws Exception {
        String tableName = "testTable";
        String tablePath = this.tempFile.getAbsolutePath() + "/" + tableName;
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)tablePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)tableName);
        this.prepareTimeline(tablePath, metaClient);
        try (CompletionTimeQueryView view = new CompletionTimeQueryView(metaClient, String.format("%08d", 3));){
            int i;
            for (i = 3; i < 7; ++i) {
                MatcherAssert.assertThat((Object)view.getCompletionTime(String.format("%08d", i)).orElse((Object)""), (Matcher)CoreMatchers.is((Object)String.format("%08d", i + 1000)));
            }
            for (i = 7; i < 11; ++i) {
                Assertions.assertTrue((boolean)view.getCompletionTime(String.format("%08d", i)).isPresent());
            }
            for (i = 1; i < 3; ++i) {
                MatcherAssert.assertThat((Object)view.getCompletionTime(String.format("%08d", i)).orElse((Object)""), (Matcher)CoreMatchers.is((Object)String.format("%08d", i + 1000)));
            }
            MatcherAssert.assertThat((String)"The cursor instant should be slided", (Object)view.getCursorInstant(), (Matcher)CoreMatchers.is((Object)String.format("%08d", 1)));
            Assertions.assertFalse((boolean)view.getCompletionTime(String.format("%08d", 11)).isPresent());
            Assertions.assertFalse((boolean)view.getCompletionTime(String.format("%08d", 12)).isPresent());
            MatcherAssert.assertThat((Object)view.getCompletionTime("111", String.format("%08d", 3)).orElse((Object)""), (Matcher)CoreMatchers.is((Object)String.format("%08d", 3)));
        }
    }

    @Test
    void testReadStartTime() throws Exception {
        String tableName = "testTable";
        String tablePath = this.tempFile.getAbsolutePath() + "/" + tableName;
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)tablePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)tableName);
        this.prepareTimeline(tablePath, metaClient);
        try (CompletionTimeQueryView view = new CompletionTimeQueryView(metaClient, String.format("%08d", 3));){
            MatcherAssert.assertThat((Object)this.getInstantTimeSetFormattedString(view, 1003, 1006), (Matcher)CoreMatchers.is((Object)"00000003,00000004,00000005,00000006"));
            MatcherAssert.assertThat((Object)this.getInstantTimeSetFormattedString(view, 1007, 1010), (Matcher)CoreMatchers.is((Object)"00000007,00000008,00000009,00000010"));
            MatcherAssert.assertThat((Object)this.getInstantTimeSetFormattedString(view, 1001, 1002), (Matcher)CoreMatchers.is((Object)"00000001,00000002"));
            MatcherAssert.assertThat((String)"The cursor instant should be slided", (Object)view.getCursorInstant(), (Matcher)CoreMatchers.is((Object)String.format("%08d", 1)));
            MatcherAssert.assertThat((Object)this.getInstantTimeSetFormattedString(view, 1010, 1011), (Matcher)CoreMatchers.is((Object)"00000010"));
            MatcherAssert.assertThat((Object)this.getInstantTimeSetFormattedString(view, 1012, 1015), (Matcher)CoreMatchers.is((Object)""));
        }
    }

    private String getInstantTimeSetFormattedString(CompletionTimeQueryView view, int completionTime1, int completionTime2) {
        return view.getStartTimes(String.format("%08d", completionTime1), String.format("%08d", completionTime2), s -> String.format("%08d", Integer.parseInt(s) - 1000)).stream().sorted().collect(Collectors.joining(","));
    }

    private void prepareTimeline(String tablePath, HoodieTableMetaClient metaClient) throws Exception {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(tablePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMarkersType("DIRECT").build();
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient);
        ArrayList<DummyActiveAction> activeActions = new ArrayList<DummyActiveAction>();
        for (int i = 1; i < 11; ++i) {
            String instantTime = String.format("%08d", i);
            String completionTime = String.format("%08d", i + 1000);
            HoodieCommitMetadata metadata = testTable.createCommitMetadata(instantTime, WriteOperationType.INSERT, Arrays.asList("par1", "par2"), 10, false);
            testTable.addCommit(instantTime, Option.of((Object)completionTime), Option.of((Object)metadata));
            activeActions.add(new DummyActiveAction(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", instantTime, completionTime), (byte[])TimelineMetadataUtils.serializeCommitMetadata((HoodieCommitMetadata)metadata).get()));
        }
        testTable.addRequestedCommit(String.format("%08d", 11));
        List instants = new HoodieActiveTimeline(metaClient, false).getInstantsAsStream().sorted().collect(Collectors.toList());
        LSMTimelineWriter writer = LSMTimelineWriter.getInstance((HoodieWriteConfig)writeConfig, (HoodieTable)this.getMockHoodieTable(metaClient));
        writer.write(activeActions.subList(0, 2), Option.empty(), Option.empty());
        writer.write(activeActions.subList(2, 4), Option.empty(), Option.empty());
        writer.write(activeActions.subList(4, 6), Option.empty(), Option.empty());
        instants.subList(0, 18).forEach(instant -> HoodieActiveTimeline.deleteInstantFile((HoodieStorage)metaClient.getStorage(), (StoragePath)metaClient.getMetaPath(), (HoodieInstant)instant));
        ValidationUtils.checkState((metaClient.reloadActiveTimeline().filterCompletedInstants().countInstants() == 4 ? 1 : 0) != 0, (String)"should archive 6 instants with 4 as active");
    }

    private HoodieTable getMockHoodieTable(HoodieTableMetaClient metaClient) {
        HoodieTable hoodieTable = (HoodieTable)Mockito.mock(HoodieTable.class);
        TaskContextSupplier taskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Mockito.when((Object)taskContextSupplier.getPartitionIdSupplier()).thenReturn(() -> 1);
        Mockito.when((Object)hoodieTable.getTaskContextSupplier()).thenReturn((Object)taskContextSupplier);
        Mockito.when((Object)hoodieTable.getMetaClient()).thenReturn((Object)metaClient);
        return hoodieTable;
    }
}

