/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.heartbeat;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieHeartbeatClient
extends HoodieCommonTestHarness {
    private static String instantTime1 = "100";
    private static String instantTime2 = "101";
    private static Long heartBeatInterval = 1000L;
    private static int numTolerableMisses = 1;

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testStartHeartbeat() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient(this.metaClient.getStorage(), this.metaClient.getBasePath().toString(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        List listFiles = this.metaClient.getStorage().listDirectEntries(new StoragePath(hoodieHeartbeatClient.getHeartbeatFolderPath()));
        Assertions.assertTrue((listFiles.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((StoragePathInfo)listFiles.get(0)).getPath().toString().contains(instantTime1));
    }

    @Test
    public void testStopHeartbeat() {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient(this.metaClient.getStorage(), this.metaClient.getBasePath().toString(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stop(instantTime1);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> hoodieHeartbeatClient.getHeartbeat(instantTime1).getNumHeartbeats() > 0);
        Integer numHeartBeats = hoodieHeartbeatClient.getHeartbeat(instantTime1).getNumHeartbeats();
        Assertions.assertTrue((numHeartBeats == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testIsHeartbeatExpired() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient(this.metaClient.getStorage(), this.metaClient.getBasePath().toString(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stop(instantTime1);
        Assertions.assertFalse((boolean)hoodieHeartbeatClient.isHeartbeatExpired(instantTime1));
    }

    @Test
    public void testNumHeartbeatsGenerated() {
        Long heartBeatInterval = 5000L;
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient(this.metaClient.getStorage(), this.metaClient.getBasePath().toString(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start("100");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> hoodieHeartbeatClient.getHeartbeat(instantTime1).getNumHeartbeats() >= 1);
    }

    @Test
    public void testDeleteWrongHeartbeat() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient(this.metaClient.getStorage(), this.metaClient.getBasePath().toString(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stop(instantTime1);
        Assertions.assertFalse((boolean)HeartbeatUtils.deleteHeartbeatFile((HoodieStorage)this.metaClient.getStorage(), (String)this.basePath, (String)instantTime2));
    }

    @Test
    public void testStopHeartbeatTimers() throws IOException {
        HoodieHeartbeatClient hoodieHeartbeatClient = new HoodieHeartbeatClient(this.metaClient.getStorage(), this.metaClient.getBasePath().toString(), heartBeatInterval, Integer.valueOf(numTolerableMisses));
        hoodieHeartbeatClient.start(instantTime1);
        hoodieHeartbeatClient.stopHeartbeatTimers();
        Assertions.assertFalse((boolean)hoodieHeartbeatClient.isHeartbeatExpired(instantTime1));
        Assertions.assertTrue((boolean)hoodieHeartbeatClient.getHeartbeat(instantTime1).isHeartbeatStopped());
    }
}

