/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTestCommitGenerator {
    public static final String BASE_FILE_WRITE_TOKEN = "1-0-1";
    public static final String LOG_FILE_WRITE_TOKEN = "0-0-0";
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTestCommitGenerator.class);

    public static void initCommitInfoForRepairTests(Map<String, List<Pair<String, String>>> baseFileInfo, Map<String, List<Pair<String, String>>> logFileInfo) {
        baseFileInfo.clear();
        logFileInfo.clear();
        baseFileInfo.put("000", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/01", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/02", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/03", (Object)UUID.randomUUID().toString())}));
        baseFileInfo.put("001", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/04", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/05", (Object)UUID.randomUUID().toString())}));
        baseFileInfo.put("002", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/06", (Object)UUID.randomUUID().toString())}));
        logFileInfo.put("001", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/03", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/06", (Object)UUID.randomUUID().toString())}));
    }

    public static void setupTimelineInFS(String basePath, Map<String, List<Pair<String, String>>> baseFileInfo, Map<String, List<Pair<String, String>>> logFileInfo, Map<String, Map<String, List<Pair<String, String>>>> instantInfoMap) throws IOException {
        instantInfoMap.clear();
        for (String instantTime : baseFileInfo.keySet()) {
            HashMap<String, List<Pair<String, String>>> partitionPathToFileIdAndNameMap = new HashMap<String, List<Pair<String, String>>>();
            ((List)baseFileInfo.getOrDefault(instantTime, new ArrayList())).forEach(e -> {
                List fileInfoList = partitionPathToFileIdAndNameMap.computeIfAbsent((String)e.getKey(), k -> new ArrayList());
                String fileId = (String)e.getValue();
                fileInfoList.add(new ImmutablePair((Object)fileId, (Object)HoodieTestCommitGenerator.getBaseFilename(instantTime, fileId)));
            });
            ((List)logFileInfo.getOrDefault(instantTime, new ArrayList())).forEach(e -> {
                List fileInfoList = partitionPathToFileIdAndNameMap.computeIfAbsent((String)e.getKey(), k -> new ArrayList());
                String fileId = (String)e.getValue();
                fileInfoList.add(new ImmutablePair((Object)fileId, (Object)HoodieTestCommitGenerator.getLogFilename(instantTime, fileId)));
            });
            HoodieTestCommitGenerator.createCommitAndDataFiles(basePath, instantTime, partitionPathToFileIdAndNameMap);
            instantInfoMap.put(instantTime, partitionPathToFileIdAndNameMap);
        }
    }

    public static String getBaseFilename(String instantTime, String fileId) {
        return FSUtils.makeBaseFileName((String)instantTime, (String)BASE_FILE_WRITE_TOKEN, (String)fileId, (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
    }

    public static String getLogFilename(String instantTime, String fileId) {
        return FSUtils.makeLogFileName((String)fileId, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantTime, (int)1, (String)LOG_FILE_WRITE_TOKEN);
    }

    public static void createCommitAndDataFiles(String basePath, String instantTime, Map<String, List<Pair<String, String>>> partitionPathToFileIdAndNameMap) throws IOException {
        String commitFilename = HoodieTimeline.makeCommitFileName((String)(instantTime + "_" + InProcessTimeGenerator.createNewInstantTime()));
        HoodieCommitMetadata commitMetadata = HoodieTestCommitGenerator.generateCommitMetadata(partitionPathToFileIdAndNameMap, Collections.emptyMap());
        HoodieTestCommitGenerator.createCommitFileWithMetadata(basePath, new Configuration(), commitFilename, (byte[])TimelineMetadataUtils.serializeCommitMetadata((HoodieCommitMetadata)commitMetadata).get());
        for (String partitionPath : partitionPathToFileIdAndNameMap.keySet()) {
            HoodieTestCommitGenerator.createPartitionMetaFile(basePath, partitionPath);
            partitionPathToFileIdAndNameMap.get(partitionPath).forEach(fileInfo -> {
                String filename = (String)fileInfo.getValue();
                try {
                    HoodieTestCommitGenerator.createDataFile(basePath, new Configuration(), partitionPath, filename);
                }
                catch (IOException e) {
                    LOG.error(String.format("Failed to create data file: %s/%s/%s", basePath, partitionPath, filename));
                }
            });
        }
    }

    public static HoodieCommitMetadata generateCommitMetadata(Map<String, List<Pair<String, String>>> partitionPathToFileIdAndNameMap, Map<String, String> extraMetadata) {
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        for (Map.Entry<String, String> entry : extraMetadata.entrySet()) {
            metadata.addMetadata(entry.getKey(), entry.getValue());
        }
        partitionPathToFileIdAndNameMap.forEach((partitionPath, fileInfoList) -> fileInfoList.forEach(fileInfo -> {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partitionPath);
            writeStat.setPath(new Path(partitionPath, (String)fileInfo.getValue()).toString());
            writeStat.setFileId((String)fileInfo.getKey());
            writeStat.setTotalWriteBytes(10000L);
            writeStat.setPrevCommit("000");
            writeStat.setNumWrites(10L);
            writeStat.setNumUpdateWrites(15L);
            writeStat.setTotalLogBlocks(2L);
            writeStat.setTotalLogRecords(100L);
            metadata.addWriteStat(partitionPath, writeStat);
        }));
        return metadata;
    }

    public static void createCommitFileWithMetadata(String basePath, Configuration configuration, String filename, byte[] content) throws IOException {
        Path commitFilePath = new Path(basePath + "/" + ".hoodie" + "/" + filename);
        try (FSDataOutputStream os = HadoopFSUtils.getFs((String)basePath, (Configuration)configuration).create(commitFilePath, true);){
            os.write(content);
        }
    }

    public static void createDataFile(String basePath, Configuration configuration, String partitionPath, String filename) throws IOException {
        Path filePath;
        Path parent;
        FileSystem fs = HadoopFSUtils.getFs((String)basePath, (Configuration)configuration);
        if (!fs.exists(parent = (filePath = new Path(new Path(basePath, partitionPath), filename)).getParent())) {
            fs.mkdirs(parent);
        }
        if (!fs.exists(filePath)) {
            fs.create(filePath);
        }
    }

    public static void createPartitionMetaFile(String basePath, String partitionPath) throws IOException {
        try {
            java.nio.file.Path parentPath = Paths.get(new URI(basePath).getPath(), partitionPath);
            Files.createDirectories(parentPath, new FileAttribute[0]);
            java.nio.file.Path metaFilePath = parentPath.resolve(".hoodie_partition_metadata");
            if (Files.notExists(metaFilePath, new LinkOption[0])) {
                Files.createFile(metaFilePath, new FileAttribute[0]);
            }
        }
        catch (URISyntaxException e) {
            throw new HoodieException("Error creating partition meta file", (Throwable)e);
        }
    }
}

