/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.SerializablePathFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListingBasedRollbackStrategy
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ListingBasedRollbackStrategy.class);
    protected final HoodieTable<?, ?, ?, ?> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String instantTime;
    protected final Boolean isRestore;

    public ListingBasedRollbackStrategy(HoodieTable<?, ?, ?, ?> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime, boolean isRestore) {
        this.table = table;
        this.context = context;
        this.config = config;
        this.instantTime = instantTime;
        this.isRestore = isRestore;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            HoodieTableMetaClient metaClient = this.table.getMetaClient();
            List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (String)this.table.getMetaClient().getBasePath(), (boolean)false);
            int numPartitions = Math.max(Math.min(partitionPaths.size(), this.config.getRollbackParallelism()), 1);
            this.context.setJobStatus(this.getClass().getSimpleName(), "Creating Listing Rollback Plan: " + this.config.getTableName());
            HoodieTableType tableType = this.table.getMetaClient().getTableType();
            String baseFileExtension = this.table.getBaseFileExtension();
            Option commitMetadataOptional = MetadataConversionUtils.getHoodieCommitMetadata((HoodieTableMetaClient)metaClient, (HoodieInstant)instantToRollback);
            Boolean isCommitMetadataCompleted = this.checkCommitMetadataCompleted(instantToRollback, (Option<HoodieCommitMetadata>)commitMetadataOptional);
            AtomicBoolean isCompaction = new AtomicBoolean(false);
            if (commitMetadataOptional.isPresent()) {
                isCompaction.set(((HoodieCommitMetadata)commitMetadataOptional.get()).getOperationType() == WriteOperationType.COMPACT);
            }
            return this.context.flatMap(partitionPaths, (SerializableFunction & Serializable)partitionPath -> {
                ArrayList<HoodieRollbackRequest> hoodieRollbackRequests = new ArrayList<HoodieRollbackRequest>(partitionPaths.size());
                Supplier<FileStatus[]> filesToDelete = () -> {
                    try {
                        return this.fetchFilesFromInstant(instantToRollback, (String)partitionPath, metaClient.getBasePath(), baseFileExtension, metaClient.getFs(), (Option<HoodieCommitMetadata>)commitMetadataOptional, isCommitMetadataCompleted, tableType);
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Fetching files to delete error", e);
                    }
                };
                if (HoodieTableType.COPY_ON_WRITE == tableType) {
                    hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, filesToDelete.get()));
                } else if (HoodieTableType.MERGE_ON_READ == tableType) {
                    this.table.getMetaClient().reloadActiveTimeline();
                    String action = instantToRollback.getAction();
                    if (isCompaction.get()) {
                        action = "compaction";
                    }
                    switch (action) {
                        case "commit": 
                        case "replacecommit": {
                            hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, filesToDelete.get()));
                            break;
                        }
                        case "compaction": {
                            if (!this.isRestore.booleanValue()) {
                                hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, this.listBaseFilesToBeDeleted(instantToRollback.getTimestamp(), baseFileExtension, (String)partitionPath, (FileSystem)metaClient.getFs())));
                                break;
                            }
                            hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, this.listAllFilesSinceCommit(instantToRollback.getTimestamp(), baseFileExtension, (String)partitionPath, metaClient)));
                            break;
                        }
                        case "deltacommit": {
                            hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, filesToDelete.get()));
                            break;
                        }
                        default: {
                            throw new HoodieRollbackException("Unknown listing type, during rollback of " + instantToRollback);
                        }
                    }
                } else {
                    throw new HoodieRollbackException(String.format("Unsupported table type: %s, during listing rollback of %s", tableType, instantToRollback));
                }
                return hoodieRollbackRequests.stream();
            }, numPartitions);
        }
        catch (Exception e) {
            LOG.error("Generating rollback requests failed for " + instantToRollback.getTimestamp(), (Throwable)e);
            throw new HoodieRollbackException("Generating rollback requests failed for " + instantToRollback.getTimestamp(), e);
        }
    }

    private FileStatus[] listAllFilesSinceCommit(String commit, String baseFileExtension, String partitionPath, HoodieTableMetaClient metaClient) throws IOException {
        LOG.info("Collecting files to be cleaned/rolledback up for path " + partitionPath + " and commit " + commit);
        CompletionTimeQueryView completionTimeQueryView = new CompletionTimeQueryView(metaClient);
        PathFilter filter = path -> {
            if (path.toString().contains(baseFileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime((String)path.getName());
                return HoodieTimeline.compareTimestamps((String)commit, (BiPredicate)HoodieTimeline.LESSER_THAN_OR_EQUALS, (String)fileCommitTime);
            }
            if (FSUtils.isLogFile((Path)path)) {
                String fileCommitTime = FSUtils.getDeltaCommitTimeFromLogPath((Path)path);
                return completionTimeQueryView.isSlicedAfterOrOn(commit, fileCommitTime);
            }
            return false;
        };
        return metaClient.getFs().listStatus(FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)partitionPath), filter);
    }

    @NotNull
    private List<HoodieRollbackRequest> getHoodieRollbackRequests(String partitionPath, FileStatus[] filesToDeletedStatus) {
        return Arrays.stream(filesToDeletedStatus).map(fileStatus -> {
            String dataFileToBeDeleted = fileStatus.getPath().toString();
            return ListingBasedRollbackStrategy.formatDeletePath(dataFileToBeDeleted);
        }).map(s -> new HoodieRollbackRequest(partitionPath, "", "", Collections.singletonList(s), Collections.emptyMap())).collect(Collectors.toList());
    }

    private static String formatDeletePath(String path) {
        return path.substring(path.indexOf(":") + 1);
    }

    private FileStatus[] listBaseFilesToBeDeleted(String commit, String basefileExtension, String partitionPath, FileSystem fs) throws IOException {
        LOG.info("Collecting files to be cleaned/rolledback up for path " + partitionPath + " and commit " + commit);
        PathFilter filter = path -> {
            if (path.toString().contains(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime((String)path.getName());
                return commit.equals(fileCommitTime);
            }
            return false;
        };
        return fs.listStatus(FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)partitionPath), filter);
    }

    private FileStatus[] fetchFilesFromInstant(HoodieInstant instantToRollback, String partitionPath, String basePath, String baseFileExtension, HoodieWrapperFileSystem fs, Option<HoodieCommitMetadata> commitMetadataOptional, Boolean isCommitMetadataCompleted, HoodieTableType tableType) throws IOException {
        if (isCommitMetadataCompleted.booleanValue() && tableType == HoodieTableType.COPY_ON_WRITE) {
            return this.fetchFilesFromCommitMetadata(instantToRollback, partitionPath, basePath, (HoodieCommitMetadata)commitMetadataOptional.get(), baseFileExtension, fs);
        }
        return this.fetchFilesFromListFiles(instantToRollback, partitionPath, basePath, baseFileExtension, fs);
    }

    private FileStatus[] fetchFilesFromCommitMetadata(HoodieInstant instantToRollback, String partitionPath, String basePath, HoodieCommitMetadata commitMetadata, String baseFileExtension, HoodieWrapperFileSystem fs) throws IOException {
        SerializablePathFilter pathFilter = ListingBasedRollbackStrategy.getSerializablePathFilter(baseFileExtension, instantToRollback.getTimestamp());
        Path[] filePaths = ListingBasedRollbackStrategy.getFilesFromCommitMetadata(basePath, commitMetadata, partitionPath);
        return fs.listStatus((Path[])Arrays.stream(filePaths).filter(entry -> {
            try {
                return fs.exists(entry);
            }
            catch (Exception e) {
                LOG.error("Exists check failed for " + entry.toString(), (Throwable)e);
                return true;
            }
        }).toArray(Path[]::new), (PathFilter)pathFilter);
    }

    private FileStatus[] fetchFilesFromListFiles(HoodieInstant instantToRollback, String partitionPath, String basePath, String baseFileExtension, HoodieWrapperFileSystem fs) throws IOException {
        SerializablePathFilter pathFilter = ListingBasedRollbackStrategy.getSerializablePathFilter(baseFileExtension, instantToRollback.getTimestamp());
        Path[] filePaths = ListingBasedRollbackStrategy.listFilesToBeDeleted(basePath, partitionPath);
        return fs.listStatus(filePaths, (PathFilter)pathFilter);
    }

    private Boolean checkCommitMetadataCompleted(HoodieInstant instantToRollback, Option<HoodieCommitMetadata> commitMetadataOptional) {
        return commitMetadataOptional.isPresent() && instantToRollback.isCompleted() && !WriteOperationType.UNKNOWN.equals((Object)((HoodieCommitMetadata)commitMetadataOptional.get()).getOperationType());
    }

    private static Path[] listFilesToBeDeleted(String basePath, String partitionPath) {
        return new Path[]{FSUtils.getPartitionPath((String)basePath, (String)partitionPath)};
    }

    private static Path[] getFilesFromCommitMetadata(String basePath, HoodieCommitMetadata commitMetadata, String partitionPath) {
        List fullPaths = commitMetadata.getFullPathsByPartitionPath(basePath, partitionPath);
        return (Path[])fullPaths.stream().map(Path::new).toArray(Path[]::new);
    }

    @NotNull
    private static SerializablePathFilter getSerializablePathFilter(String basefileExtension, String commit) {
        return path -> {
            if (path.toString().endsWith(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime((String)path.getName());
                return commit.equals(fileCommitTime);
            }
            if (FSUtils.isLogFile((Path)path)) {
                String fileCommitTime = FSUtils.getDeltaCommitTimeFromLogPath((Path)path);
                return commit.equals(fileCommitTime);
            }
            return false;
        };
    }
}

