/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index.functional;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieFunctionalIndexClient {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieFunctionalIndexClient.class);

    public void register(HoodieTableMetaClient metaClient, String indexName, String indexType, Map<String, Map<String, String>> columns, Map<String, String> options) {
        LOG.info("Registering index {} of using {}", (Object)indexName, (Object)indexType);
        String indexMetaPath = (String)metaClient.getTableConfig().getIndexDefinitionPath().orElse((Object)(metaClient.getMetaPath() + "/" + ".index_defs" + "/" + "index.json"));
        metaClient.buildFunctionalIndexDefinition(indexMetaPath, indexName, indexType, columns, options);
        if (!metaClient.getTableConfig().getProps().containsKey((Object)HoodieTableConfig.INDEX_DEFINITION_PATH) || !metaClient.getTableConfig().getIndexDefinitionPath().isPresent()) {
            metaClient.getTableConfig().setValue(HoodieTableConfig.INDEX_DEFINITION_PATH, indexMetaPath);
            HoodieTableConfig.update((FileSystem)metaClient.getFs(), (Path)new Path(metaClient.getMetaPath()), (Properties)metaClient.getTableConfig().getProps());
        }
    }

    public abstract void create(HoodieTableMetaClient var1, String var2, String var3, Map<String, Map<String, String>> var4, Map<String, String> var5);
}

