/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.io.AppendHandleFactory;
import org.apache.hudi.io.SingleFileHandleCreateFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BucketIndexBulkInsertPartitioner<T>
implements BulkInsertPartitioner<T> {
    public static final Logger LOG = LogManager.getLogger(BucketIndexBulkInsertPartitioner.class);
    private final boolean preserveHoodieMetadata;
    protected final String[] sortColumnNames;
    protected final boolean consistentLogicalTimestampEnabled;
    protected final HoodieTable table;
    protected final List<String> indexKeyFields;
    protected final List<Boolean> doAppend = new ArrayList<Boolean>();
    protected final List<String> fileIdPfxList = new ArrayList<String>();

    public BucketIndexBulkInsertPartitioner(HoodieTable table, String sortString, boolean preserveHoodieMetadata) {
        this.table = table;
        this.indexKeyFields = Arrays.asList(table.getConfig().getBucketIndexHashField().split(","));
        this.consistentLogicalTimestampEnabled = table.getConfig().isConsistentLogicalTimestampEnabled();
        this.sortColumnNames = sortString != null ? sortString.split(",") : null;
        this.preserveHoodieMetadata = preserveHoodieMetadata;
    }

    @Override
    public Option<WriteHandleFactory> getWriteHandleFactory(int idx) {
        return this.doAppend.get(idx) != false ? Option.of(new AppendHandleFactory()) : Option.of(new SingleFileHandleCreateFactory(FSUtils.createNewFileId((String)this.getFileIdPfx(idx), (int)0), this.preserveHoodieMetadata));
    }

    @Override
    public String getFileIdPfx(int partitionId) {
        return this.fileIdPfxList.get(partitionId);
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return this.sortColumnNames != null && this.sortColumnNames.length > 0 || this.table.requireSortedRecords() || this.table.getConfig().getBulkInsertSortMode() != BulkInsertSortMode.NONE;
    }
}

