/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class CustomAvroKeyGenerator
extends BaseKeyGenerator {
    public static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    public static final String SPLIT_REGEX = ":";
    private final List<BaseKeyGenerator> partitionKeyGenerators;
    private final BaseKeyGenerator recordKeyGenerator;

    public CustomAvroKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = (List)Option.ofNullable((Object)props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)).map(recordKeyConfigValue -> Arrays.stream(recordKeyConfigValue.split(",")).map(String::trim).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).collect(Collectors.toList());
        this.recordKeyGenerator = this.getRecordKeyFieldNames().size() == 1 ? new SimpleAvroKeyGenerator(this.config) : new ComplexAvroKeyGenerator(this.config);
        this.partitionKeyGenerators = CustomAvroKeyGenerator.getPartitionKeyGenerators(this.partitionPathFields, this.config);
    }

    private static List<BaseKeyGenerator> getPartitionKeyGenerators(List<String> partitionPathFields, TypedProperties config) {
        if (partitionPathFields.size() == 1 && partitionPathFields.get(0).isEmpty()) {
            return Collections.emptyList();
        }
        return partitionPathFields.stream().map(field -> {
            String[] fieldWithType = field.split(SPLIT_REGEX);
            if (fieldWithType.length != 2) {
                throw new HoodieKeyException("Unable to find field names for partition path in proper format");
            }
            String partitionPathField = fieldWithType[0];
            PartitionKeyType keyType = PartitionKeyType.valueOf(fieldWithType[1].toUpperCase());
            switch (keyType) {
                case SIMPLE: {
                    return new SimpleAvroKeyGenerator(config, partitionPathField);
                }
                case TIMESTAMP: {
                    try {
                        return new TimestampBasedAvroKeyGenerator(config, partitionPathField);
                    }
                    catch (IOException e) {
                        throw new HoodieKeyGeneratorException("Unable to initialise TimestampBasedKeyGenerator class", e);
                    }
                }
            }
            throw new HoodieKeyGeneratorException("Please provide valid PartitionKeyType with fields! You provided: " + (Object)((Object)keyType));
        }).collect(Collectors.toList());
    }

    public String getPartitionPath(GenericRecord record) {
        if (this.getPartitionPathFields() == null) {
            throw new HoodieKeyException("Unable to find field names for partition path in cfg");
        }
        if (this.partitionKeyGenerators.isEmpty()) {
            return "";
        }
        StringBuilder partitionPath = new StringBuilder();
        for (int i = 0; i < this.partitionKeyGenerators.size(); ++i) {
            BaseKeyGenerator partitionKeyGenerator = this.partitionKeyGenerators.get(i);
            partitionPath.append(partitionKeyGenerator.getPartitionPath(record));
            if (i == this.partitionKeyGenerators.size() - 1) continue;
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        return partitionPath.toString();
    }

    public String getRecordKey(GenericRecord record) {
        this.validateRecordKeyFields();
        return this.recordKeyGenerator.getRecordKey(record);
    }

    private void validateRecordKeyFields() {
        if (this.getRecordKeyFieldNames() == null || this.getRecordKeyFieldNames().isEmpty()) {
            throw new HoodieKeyException("Unable to find field names for record key in cfg");
        }
    }

    public String getDefaultPartitionPathSeparator() {
        return DEFAULT_PARTITION_PATH_SEPARATOR;
    }

    public static enum PartitionKeyType {
        SIMPLE,
        TIMESTAMP;

    }
}

