/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.LogFileCreationCallback;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieWriteHandle<T, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteHandle.class);
    protected final Schema writeSchema;
    protected final Schema writeSchemaWithMetaFields;
    protected final HoodieRecordMerger recordMerger;
    protected HoodieTimer timer;
    protected WriteStatus writeStatus;
    protected HoodieRecordLocation newRecordLocation;
    protected final String partitionPath;
    protected final String fileId;
    protected final String writeToken;
    protected final TaskContextSupplier taskContextSupplier;
    protected final boolean schemaOnReadEnabled;
    private boolean closed = false;

    public HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, partitionPath, fileId, hoodieTable, (Option<Schema>)Option.empty(), taskContextSupplier);
    }

    protected HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier) {
        super(config, (Option<String>)Option.of((Object)instantTime), hoodieTable);
        this.partitionPath = partitionPath;
        this.fileId = fileId;
        this.writeSchema = (Schema)overriddenSchema.orElseGet(() -> HoodieWriteHandle.getWriteSchema(config));
        this.writeSchemaWithMetaFields = HoodieAvroUtils.addMetadataFields((Schema)this.writeSchema, (boolean)config.allowOperationMetadataField());
        this.timer = HoodieTimer.start();
        this.newRecordLocation = new HoodieRecordLocation(instantTime, fileId);
        this.taskContextSupplier = taskContextSupplier;
        this.writeToken = this.makeWriteToken();
        this.schemaOnReadEnabled = !StringUtils.isNullOrEmpty((String)hoodieTable.getConfig().getInternalSchema());
        this.recordMerger = config.getRecordMerger();
        this.writeStatus = (WriteStatus)ReflectionUtils.loadClass((String)config.getWriteStatusClassName(), (Object[])new Object[]{hoodieTable.shouldTrackSuccessRecords(), config.getWriteStatusFailureFraction()});
    }

    private String makeWriteToken() {
        return FSUtils.makeWriteToken((int)this.getPartitionId(), (int)this.getStageId(), (long)this.getAttemptId());
    }

    public Path makeNewPath(String partitionPath) {
        Path path = FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)partitionPath);
        try {
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        return new Path(path.toString(), FSUtils.makeBaseFileName((String)this.instantTime, (String)this.writeToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension()));
    }

    protected Path makeNewFilePath(String partitionPath, String fileName) {
        String relativePath = new Path((partitionPath.isEmpty() ? "" : partitionPath + "/") + fileName).toString();
        return new Path(this.config.getBasePath(), relativePath);
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkersFactory.get(this.config.getMarkersType(), this.hoodieTable, this.instantTime).create(partitionPath, dataFileName, this.getIOType(), this.config, this.fileId, this.hoodieTable.getMetaClient().getActiveTimeline());
    }

    public Schema getWriterSchemaWithMetaFields() {
        return this.writeSchemaWithMetaFields;
    }

    public Schema getWriterSchema() {
        return this.writeSchema;
    }

    public boolean canWrite(HoodieRecord record) {
        return false;
    }

    boolean layoutControlsNumFiles() {
        return this.hoodieTable.getStorageLayout().determinesNumFileGroups();
    }

    protected void doWrite(HoodieRecord record, Schema schema, TypedProperties props) {
    }

    public void write(HoodieRecord record, Schema schema, TypedProperties props) {
        this.doWrite(record, schema, props);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void markClosed() {
        this.closed = true;
    }

    public abstract List<WriteStatus> close();

    public List<WriteStatus> writeStatuses() {
        return Collections.singletonList(this.writeStatus);
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public abstract IOType getIOType();

    @Override
    public FileSystem getFileSystem() {
        return this.hoodieTable.getMetaClient().getFs();
    }

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieTableMetaClient getHoodieTableMetaClient() {
        return this.hoodieTable.getMetaClient();
    }

    public String getFileId() {
        return this.fileId;
    }

    protected int getPartitionId() {
        return (Integer)this.taskContextSupplier.getPartitionIdSupplier().get();
    }

    protected int getStageId() {
        return (Integer)this.taskContextSupplier.getStageIdSupplier().get();
    }

    protected long getAttemptId() {
        return (Long)this.taskContextSupplier.getAttemptIdSupplier().get();
    }

    private static Schema getWriteSchema(HoodieWriteConfig config) {
        return new Schema.Parser().parse(config.getWriteSchema());
    }

    protected HoodieLogFormat.Writer createLogWriter(String deltaCommitTime) {
        return this.createLogWriter(deltaCommitTime, null);
    }

    protected HoodieLogFormat.Writer createLogWriter(String deltaCommitTime, String fileSuffix) {
        try {
            return HoodieLogFormat.newWriterBuilder().onParentPath(FSUtils.getPartitionPath((String)this.hoodieTable.getMetaClient().getBasePath(), (String)this.partitionPath)).withFileId(this.fileId).withDeltaCommit(deltaCommitTime).withFileSize(0L).withSizeThreshold(this.config.getLogFileMaxSize()).withFs(this.fs).withRolloverLogWriteToken(this.writeToken).withLogWriteToken(this.writeToken).withFileCreationCallback(this.getLogCreationCallback()).withSuffix(fileSuffix).withFileExtension(".log").build();
        }
        catch (IOException e) {
            throw new HoodieException("Creating logger writer with fileId: " + this.fileId + ", delta commit time: " + deltaCommitTime + ", file suffix: " + fileSuffix + " error");
        }
    }

    protected LogFileCreationCallback getLogCreationCallback() {
        return new LogFileCreationCallback(){

            public boolean preFileCreation(HoodieLogFile logFile) {
                WriteMarkers writeMarkers = WriteMarkersFactory.get(HoodieWriteHandle.this.config.getMarkersType(), HoodieWriteHandle.this.hoodieTable, HoodieWriteHandle.this.instantTime);
                return writeMarkers.createIfNotExists(HoodieWriteHandle.this.partitionPath, logFile.getFileName(), IOType.CREATE, HoodieWriteHandle.this.config, HoodieWriteHandle.this.fileId, HoodieWriteHandle.this.hoodieTable.getMetaClient().getActiveTimeline()).isPresent();
            }
        };
    }

    protected static Option<IndexedRecord> toAvroRecord(HoodieRecord record, Schema writerSchema, TypedProperties props) {
        try {
            return record.toIndexedRecord(writerSchema, (Properties)props).map(HoodieRecord::getData);
        }
        catch (IOException e) {
            LOG.error("Fail to get indexRecord from " + record, (Throwable)e);
            return Option.empty();
        }
    }
}

