/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;

@ConfigClassProperty(name="Payload Configurations", groupName=ConfigGroups.Names.RECORD_PAYLOAD, description="Payload related configs, that can be leveraged to control merges based on specific business fields in the data.")
public class HoodiePayloadConfig
extends HoodieConfig {
    public static final ConfigProperty<String> EVENT_TIME_FIELD = ConfigProperty.key((String)"hoodie.payload.event.time.field").defaultValue((Object)"ts").markAdvanced().withDocumentation("Table column/field name to derive timestamp associated with the records. This canbe useful for e.g, determining the freshness of the table.");
    public static final ConfigProperty<String> PAYLOAD_CLASS_NAME = ConfigProperty.key((String)"hoodie.compaction.payload.class").defaultValue((Object)OverwriteWithLatestAvroPayload.class.getName()).markAdvanced().withDocumentation("This needs to be same as class used during insert/upserts. Just like writing, compaction also uses the record payload class to merge records in the log against each other, merge again with the base file and produce the final record to be written after compaction.");
    @Deprecated
    public static final ConfigProperty<String> ORDERING_FIELD = ConfigProperty.key((String)"hoodie.payload.ordering.field").defaultValue((Object)"ts").markAdvanced().withDocumentation("Table column/field name to order records that have the same key, before merging and writing to storage.");
    @Deprecated
    public static final String DEFAULT_PAYLOAD_CLASS = (String)PAYLOAD_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String PAYLOAD_CLASS_PROP = PAYLOAD_CLASS_NAME.key();

    private HoodiePayloadConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodiePayloadConfig payloadConfig = new HoodiePayloadConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.payloadConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.payloadConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withPayloadOrderingField(String payloadOrderingField) {
            this.payloadConfig.setValue(ORDERING_FIELD, String.valueOf(payloadOrderingField));
            return this;
        }

        public Builder withPayloadEventTimeField(String payloadEventTimeField) {
            this.payloadConfig.setValue(EVENT_TIME_FIELD, String.valueOf(payloadEventTimeField));
            return this;
        }

        public Builder withPayloadClass(String payloadClassName) {
            this.payloadConfig.setValue(PAYLOAD_CLASS_NAME, payloadClassName);
            return this;
        }

        public HoodiePayloadConfig build() {
            this.payloadConfig.setDefaults(HoodiePayloadConfig.class.getName());
            return this.payloadConfig;
        }
    }
}

