/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.text.ParseException;
import java.time.Instant;
import org.apache.hudi.client.timeline.HoodieTimelineArchiver;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTimelineArchiver.class);

    public static Pair<Integer, Integer> getMinAndMaxInstantsToKeep(HoodieTable<?, ?, ?, ?> table, HoodieTableMetaClient metaClient) {
        int minInstantsToKeep;
        int maxInstantsToKeep;
        HoodieWriteConfig config = table.getConfig();
        HoodieTimeline completedCommitsTimeline = table.getCompletedCommitsTimeline();
        Option latestCommit = completedCommitsTimeline.lastInstant();
        HoodieCleaningPolicy cleanerPolicy = config.getCleanerPolicy();
        int cleanerCommitsRetained = config.getCleanerCommitsRetained();
        int cleanerHoursRetained = config.getCleanerHoursRetained();
        Option<HoodieInstant> earliestCommitToRetain = ArchivalUtils.getEarliestCommitToRetain(metaClient, (Option<HoodieInstant>)latestCommit, cleanerPolicy, cleanerCommitsRetained, cleanerHoursRetained);
        int configuredMinInstantsToKeep = config.getMinCommitsToKeep();
        int configuredMaxInstantsToKeep = config.getMaxCommitsToKeep();
        if (earliestCommitToRetain.isPresent()) {
            int minInstantsToKeepBasedOnCleaning = completedCommitsTimeline.findInstantsAfter(((HoodieInstant)earliestCommitToRetain.get()).getTimestamp()).countInstants() + 2;
            if (configuredMinInstantsToKeep < minInstantsToKeepBasedOnCleaning) {
                maxInstantsToKeep = minInstantsToKeepBasedOnCleaning + configuredMaxInstantsToKeep - configuredMinInstantsToKeep;
                minInstantsToKeep = minInstantsToKeepBasedOnCleaning;
                LOG.warn("The configured archival configs {}={} is more aggressive than the cleaning configs as the earliest commit to retain is {}. Adjusted the archival configs to be {}={} and {}={}", new Object[]{HoodieArchivalConfig.MIN_COMMITS_TO_KEEP.key(), configuredMinInstantsToKeep, earliestCommitToRetain.get(), HoodieArchivalConfig.MIN_COMMITS_TO_KEEP.key(), minInstantsToKeep, HoodieArchivalConfig.MAX_COMMITS_TO_KEEP.key(), maxInstantsToKeep});
                switch (cleanerPolicy) {
                    case KEEP_LATEST_COMMITS: {
                        LOG.warn("Cleaning configs: {}=KEEP_LATEST_COMMITS {}={}", new Object[]{HoodieCleanConfig.CLEANER_POLICY.key(), HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key(), cleanerCommitsRetained});
                        break;
                    }
                    case KEEP_LATEST_BY_HOURS: {
                        LOG.warn("Cleaning configs: {}=KEEP_LATEST_BY_HOURS {}={}", new Object[]{HoodieCleanConfig.CLEANER_POLICY.key(), HoodieCleanConfig.CLEANER_HOURS_RETAINED.key(), cleanerHoursRetained});
                        break;
                    }
                    case KEEP_LATEST_FILE_VERSIONS: {
                        LOG.warn("Cleaning configs: {}=CLEANER_FILE_VERSIONS_RETAINED {}={}", new Object[]{HoodieCleanConfig.CLEANER_POLICY.key(), HoodieCleanConfig.CLEANER_FILE_VERSIONS_RETAINED.key(), config.getCleanerFileVersionsRetained()});
                        break;
                    }
                }
            } else {
                maxInstantsToKeep = configuredMaxInstantsToKeep;
                minInstantsToKeep = configuredMinInstantsToKeep;
            }
        } else {
            maxInstantsToKeep = configuredMaxInstantsToKeep;
            minInstantsToKeep = configuredMinInstantsToKeep;
        }
        return Pair.of((Object)minInstantsToKeep, (Object)maxInstantsToKeep);
    }

    private static Option<HoodieInstant> getEarliestCommitToRetain(HoodieTableMetaClient metaClient, Option<HoodieInstant> latestCommit, HoodieCleaningPolicy cleanerPolicy, int cleanerCommitsRetained, int cleanerHoursRetained) {
        Option earliestCommitToRetain;
        block2: {
            earliestCommitToRetain = Option.empty();
            try {
                earliestCommitToRetain = CleanerUtils.getEarliestCommitToRetain((HoodieTimeline)metaClient.getActiveTimeline().getCommitsTimeline(), (HoodieCleaningPolicy)cleanerPolicy, (int)cleanerCommitsRetained, (Instant)(latestCommit.isPresent() ? HoodieActiveTimeline.parseDateFromInstantTime((String)((HoodieInstant)latestCommit.get()).getTimestamp()).toInstant() : Instant.now()), (int)cleanerHoursRetained, (HoodieTimelineTimeZone)metaClient.getTableConfig().getTimelineTimezone());
            }
            catch (ParseException e) {
                if (!HoodieActiveTimeline.NOT_PARSABLE_TIMESTAMPS.stream().noneMatch(ts -> ((HoodieInstant)latestCommit.get()).getTimestamp().startsWith((String)ts))) break block2;
                LOG.warn("Error parsing instant time: " + ((HoodieInstant)latestCommit.get()).getTimestamp());
            }
        }
        return earliestCommitToRetain;
    }
}

