/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hudi.async.HoodieAsyncTableService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCleanerService
extends HoodieAsyncTableService {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncCleanerService.class);
    private final BaseHoodieWriteClient writeClient;
    private final transient ExecutorService executor = Executors.newSingleThreadExecutor();

    protected AsyncCleanerService(BaseHoodieWriteClient writeClient) {
        super(writeClient.getConfig());
        this.writeClient = writeClient;
    }

    @Override
    protected Pair<CompletableFuture, ExecutorService> startService() {
        String instantTime = this.writeClient.createNewInstantTime();
        LOG.info(String.format("Starting async clean service with instant time %s...", instantTime));
        return Pair.of(CompletableFuture.supplyAsync(() -> {
            this.writeClient.clean(instantTime);
            return true;
        }, this.executor), (Object)this.executor);
    }

    public static AsyncCleanerService startAsyncCleaningIfEnabled(BaseHoodieWriteClient writeClient) {
        HoodieWriteConfig config = writeClient.getConfig();
        if (!config.isAutoClean() || !config.isAsyncClean()) {
            LOG.info("The HoodieWriteClient is not configured to auto & async clean. Async clean service will not start.");
            return null;
        }
        AsyncCleanerService asyncCleanerService = new AsyncCleanerService(writeClient);
        asyncCleanerService.start(null);
        return asyncCleanerService;
    }

    public static void waitForCompletion(AsyncCleanerService asyncCleanerService) {
        if (asyncCleanerService != null) {
            LOG.info("Waiting for async clean service to finish");
            try {
                asyncCleanerService.waitForShutdown();
            }
            catch (Exception e) {
                throw new HoodieException("Error waiting for async clean service to finish", (Throwable)e);
            }
        }
    }

    public static void forceShutdown(AsyncCleanerService asyncCleanerService) {
        if (asyncCleanerService != null) {
            LOG.info("Shutting down async clean service...");
            asyncCleanerService.shutdown(true);
        }
    }
}

