/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.upgrade.DowngradeHandler;

public abstract class BaseTwoToOneDowngradeHandler
implements DowngradeHandler {
    @Override
    public Map<ConfigProperty, String> downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime) {
        HoodieTable table = this.getTable(config, context);
        HoodieTableMetaClient metaClient = table.getMetaClient();
        HoodieTimeline inflightTimeline = metaClient.getCommitsTimeline().filterPendingExcludingCompaction();
        List commits = inflightTimeline.getReverseOrderedInstants().collect(Collectors.toList());
        for (HoodieInstant inflightInstant : commits) {
            try {
                this.convertToDirectMarkers(inflightInstant.getTimestamp(), table, context, config.getMarkersDeleteParallelism());
            }
            catch (IOException e) {
                throw new HoodieException("Converting marker files to DIRECT style failed during downgrade", (Throwable)e);
            }
        }
        return Collections.EMPTY_MAP;
    }

    abstract HoodieTable getTable(HoodieWriteConfig var1, HoodieEngineContext var2);

    private void convertToDirectMarkers(String commitInstantTime, HoodieTable table, HoodieEngineContext context, int parallelism) throws IOException {
        block4: {
            FileSystem fileSystem;
            String markerDir;
            block3: {
                markerDir = table.getMetaClient().getMarkerFolderPath(commitInstantTime);
                fileSystem = FSUtils.getFs((String)markerDir, (Configuration)context.getHadoopConf().newCopy());
                Option markerTypeOption = MarkerUtils.readMarkerType((FileSystem)fileSystem, (String)markerDir);
                if (!markerTypeOption.isPresent()) break block3;
                switch ((MarkerType)markerTypeOption.get()) {
                    case TIMELINE_SERVER_BASED: {
                        Map markersMap = MarkerUtils.readTimelineServerBasedMarkersFromFileSystem((String)markerDir, (FileSystem)fileSystem, (HoodieEngineContext)context, (int)parallelism);
                        DirectWriteMarkers directWriteMarkers = new DirectWriteMarkers(table, commitInstantTime);
                        markersMap.values().stream().flatMap(Collection::stream).forEach(directWriteMarkers::create);
                        MarkerUtils.deleteMarkerTypeFile((FileSystem)fileSystem, (String)markerDir);
                        this.deleteTimelineBasedMarkerFiles(markerDir, fileSystem);
                        break block4;
                    }
                    default: {
                        throw new HoodieException("The marker type \"" + ((MarkerType)markerTypeOption.get()).name() + "\" is not supported for rollback.");
                    }
                }
            }
            this.deleteTimelineBasedMarkerFiles(markerDir, fileSystem);
        }
    }

    private void deleteTimelineBasedMarkerFiles(String markerDir, FileSystem fileSystem) throws IOException {
        Path dirPath = new Path(markerDir);
        FileStatus[] fileStatuses = fileSystem.listStatus(dirPath);
        Predicate<FileStatus> prefixFilter = fileStatus -> fileStatus.getPath().getName().startsWith("MARKERS");
        List<String> markerDirSubPaths = Arrays.stream(fileStatuses).filter(prefixFilter).map(fileStatus -> fileStatus.getPath().toString()).collect(Collectors.toList());
        markerDirSubPaths.forEach(fileToDelete -> {
            try {
                fileSystem.delete(new Path(fileToDelete), false);
            }
            catch (IOException e) {
                Log.warn((String)"Deleting Timeline based marker files failed ", (Throwable)e);
            }
        });
    }
}

