/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.DowngradeHandler;

public abstract class BaseOneToZeroDowngradeHandler
implements DowngradeHandler {
    @Override
    public Map<ConfigProperty, String> downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime) {
        HoodieTable table = this.getTable(config, context);
        HoodieTimeline inflightTimeline = table.getMetaClient().getCommitsTimeline().filterPendingExcludingCompaction();
        List commits = inflightTimeline.getReverseOrderedInstants().collect(Collectors.toList());
        for (HoodieInstant inflightInstant : commits) {
            WriteMarkers writeMarkers = WriteMarkersFactory.get(config.getMarkersType(), table, inflightInstant.getTimestamp());
            writeMarkers.quietDeleteMarkerDir(context, config.getMarkersDeleteParallelism());
        }
        return Collections.EMPTY_MAP;
    }

    abstract HoodieTable getTable(HoodieWriteConfig var1, HoodieEngineContext var2);
}

