/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.StorageSchemes;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkers;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WriteMarkersFactory {
    private static final Logger LOG = LogManager.getLogger(WriteMarkersFactory.class);

    public static WriteMarkers get(MarkerType markerType, HoodieTable table, String instantTime) {
        LOG.debug((Object)("Instantiated MarkerFiles with marker type: " + markerType.toString()));
        switch (markerType) {
            case DIRECT: {
                return new DirectWriteMarkers(table, instantTime);
            }
            case TIMELINE_SERVER_BASED: {
                String basePath = table.getMetaClient().getBasePath();
                if (StorageSchemes.HDFS.getScheme().equals(FSUtils.getFs((String)basePath, (Configuration)table.getContext().getHadoopConf().newCopy()).getScheme())) {
                    throw new HoodieException("Timeline-server-based markers are not supported for HDFS: base path " + basePath);
                }
                return new TimelineServerBasedWriteMarkers(table, instantTime);
            }
        }
        throw new HoodieException("The marker type \"" + markerType.name() + "\" is not supported.");
    }
}

