/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseRollbackActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieRollbackMetadata> {
    private static final Logger LOG = LogManager.getLogger(BaseRollbackActionExecutor.class);
    protected final HoodieInstant instantToRollback;
    protected final boolean deleteInstants;
    protected final boolean skipTimelinePublish;
    protected final boolean useMarkerBasedStrategy;

    public BaseRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant instantToRollback, boolean deleteInstants) {
        this(context, config, table, instantTime, instantToRollback, deleteInstants, false, config.shouldRollbackUsingMarkers());
    }

    public BaseRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant instantToRollback, boolean deleteInstants, boolean skipTimelinePublish, boolean useMarkerBasedStrategy) {
        super(context, config, table, instantTime);
        this.instantToRollback = instantToRollback;
        this.deleteInstants = deleteInstants;
        this.skipTimelinePublish = skipTimelinePublish;
        this.useMarkerBasedStrategy = useMarkerBasedStrategy;
        if (useMarkerBasedStrategy) {
            ValidationUtils.checkArgument((!instantToRollback.isCompleted() ? 1 : 0) != 0, (String)("Cannot use marker based rollback strategy on completed instant:" + instantToRollback));
        }
    }

    protected abstract RollbackStrategy getRollbackStrategy();

    protected abstract List<HoodieRollbackStat> executeRollback() throws IOException;

    protected abstract List<HoodieRollbackStat> executeRollbackUsingFileListing(HoodieInstant var1);

    @Override
    public HoodieRollbackMetadata execute() {
        HoodieTimer rollbackTimer = new HoodieTimer().startTimer();
        List<HoodieRollbackStat> stats = this.doRollbackAndGetStats();
        HoodieRollbackMetadata rollbackMetadata = TimelineMetadataUtils.convertRollbackMetadata((String)this.instantTime, (Option)Option.of((Object)rollbackTimer.endTimer()), Collections.singletonList(this.instantToRollback), stats);
        if (!this.skipTimelinePublish) {
            this.finishRollback(rollbackMetadata);
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), this.table, this.instantToRollback.getTimestamp()).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        return rollbackMetadata;
    }

    private void validateSavepointRollbacks() {
        List<String> savepoints = this.table.getCompletedSavepointTimeline().getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        savepoints.forEach(s -> {
            if (s.contains(this.instantToRollback.getTimestamp())) {
                throw new HoodieRollbackException("Could not rollback a savepointed commit. Delete savepoint first before rolling back" + s);
            }
        });
    }

    private void validateRollbackCommitSequence() {
        if (this.config.getFailedWritesCleanPolicy().isEager()) {
            String instantTimeToRollback = this.instantToRollback.getTimestamp();
            HoodieTimeline commitTimeline = this.table.getCompletedCommitsTimeline();
            HoodieTimeline inflightAndRequestedCommitTimeline = this.table.getPendingCommitTimeline();
            if (instantTimeToRollback != null && !commitTimeline.empty() && !commitTimeline.findInstantsAfter(instantTimeToRollback, Integer.MAX_VALUE).empty()) {
                try {
                    if (!HoodieHeartbeatClient.heartbeatExists((FileSystem)this.table.getMetaClient().getFs(), this.config.getBasePath(), instantTimeToRollback).booleanValue()) {
                        throw new HoodieRollbackException("Found commits after time :" + instantTimeToRollback + ", please rollback greater commits first");
                    }
                }
                catch (IOException io) {
                    throw new HoodieRollbackException("Unable to rollback commits ", io);
                }
            }
            List inflights = inflightAndRequestedCommitTimeline.getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
            if (instantTimeToRollback != null && !inflights.isEmpty() && inflights.indexOf(instantTimeToRollback) != inflights.size() - 1) {
                throw new HoodieRollbackException("Found in-flight commits after time :" + instantTimeToRollback + ", please rollback greater commits first");
            }
        }
    }

    private void rollBackIndex() {
        if (!this.table.getIndex().rollbackCommit(this.instantToRollback.getTimestamp())) {
            throw new HoodieRollbackException("Rollback index changes failed, for time :" + this.instantToRollback);
        }
        LOG.info((Object)("Index rolled back for commits " + this.instantToRollback));
    }

    public List<HoodieRollbackStat> doRollbackAndGetStats() {
        String instantTimeToRollback = this.instantToRollback.getTimestamp();
        boolean isPendingCompaction = Objects.equals("compaction", this.instantToRollback.getAction()) && !this.instantToRollback.isCompleted();
        boolean isPendingClustering = Objects.equals("replacecommit", this.instantToRollback.getAction()) && !this.instantToRollback.isCompleted() && ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)this.table.getMetaClient(), (HoodieInstant)this.instantToRollback).isPresent();
        this.validateSavepointRollbacks();
        if (!isPendingCompaction && !isPendingClustering) {
            this.validateRollbackCommitSequence();
        }
        try {
            List<HoodieRollbackStat> stats = this.executeRollback();
            LOG.info((Object)("Rolled back inflight instant " + instantTimeToRollback));
            if (!isPendingCompaction) {
                this.rollBackIndex();
            }
            return stats;
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to execute rollback ", e);
        }
    }

    protected void finishRollback(HoodieRollbackMetadata rollbackMetadata) throws HoodieIOException {
        try {
            this.table.getActiveTimeline().createNewInstant(new HoodieInstant(HoodieInstant.State.INFLIGHT, "rollback", this.instantTime));
            this.table.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "rollback", this.instantTime), TimelineMetadataUtils.serializeRollbackMetadata((HoodieRollbackMetadata)rollbackMetadata));
            LOG.info((Object)("Rollback of Commits " + rollbackMetadata.getCommitsRollback() + " is complete"));
        }
        catch (IOException e) {
            throw new HoodieIOException("Error executing rollback at instant " + this.instantTime, e);
        }
    }

    protected void deleteInflightAndRequestedInstant(boolean deleteInstant, HoodieActiveTimeline activeTimeline, HoodieInstant instantToBeDeleted) {
        if (deleteInstant) {
            LOG.info((Object)("Deleting instant=" + instantToBeDeleted));
            activeTimeline.deletePending(instantToBeDeleted);
            if (instantToBeDeleted.isInflight() && !this.table.getMetaClient().getTimelineLayoutVersion().isNullVersion()) {
                instantToBeDeleted = new HoodieInstant(HoodieInstant.State.REQUESTED, instantToBeDeleted.getAction(), instantToBeDeleted.getTimestamp());
                activeTimeline.deletePending(instantToBeDeleted);
            }
            LOG.info((Object)("Deleted pending commit " + instantToBeDeleted));
        } else {
            LOG.warn((Object)("Rollback finished without deleting inflight instant file. Instant=" + instantToBeDeleted));
        }
    }

    protected void dropBootstrapIndexIfNeeded(HoodieInstant instantToRollback) {
        if (HoodieTimeline.compareTimestamps((String)instantToRollback.getTimestamp(), (BiPredicate)HoodieTimeline.EQUALS, (String)"00000000000001")) {
            LOG.info((Object)"Dropping bootstrap index as metadata bootstrap commit is getting rolled back !!");
            BootstrapIndex.getBootstrapIndex((HoodieTableMetaClient)this.table.getMetaClient()).dropIndex();
        }
    }

    static interface RollbackStrategy
    extends Serializable {
        public List<HoodieRollbackStat> execute(HoodieInstant var1);
    }
}

