/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackActionExecutor;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractMarkerBasedRollbackStrategy<T extends HoodieRecordPayload, I, K, O>
implements BaseRollbackActionExecutor.RollbackStrategy {
    private static final Logger LOG = LogManager.getLogger(AbstractMarkerBasedRollbackStrategy.class);
    protected final HoodieTable<T, I, K, O> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    protected final String instantTime;

    public AbstractMarkerBasedRollbackStrategy(HoodieTable<T, I, K, O> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        this.table = table;
        this.context = context;
        this.basePath = table.getMetaClient().getBasePath();
        this.config = config;
        this.instantTime = instantTime;
    }

    protected HoodieRollbackStat undoMerge(String mergedBaseFilePath) throws IOException {
        LOG.info((Object)("Rolling back by deleting the merged base file:" + mergedBaseFilePath));
        return this.deleteBaseFile(mergedBaseFilePath);
    }

    protected HoodieRollbackStat undoCreate(String createdBaseFilePath) throws IOException {
        LOG.info((Object)("Rolling back by deleting the created base file:" + createdBaseFilePath));
        return this.deleteBaseFile(createdBaseFilePath);
    }

    private HoodieRollbackStat deleteBaseFile(String baseFilePath) throws IOException {
        Path fullDeletePath = new Path(this.basePath, baseFilePath);
        String partitionPath = FSUtils.getRelativePartitionPath((Path)new Path(this.basePath), (Path)fullDeletePath.getParent());
        boolean isDeleted = this.table.getMetaClient().getFs().delete(fullDeletePath);
        return HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath).withDeletedFileResult(baseFilePath, isDeleted).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HoodieRollbackStat undoAppend(String appendBaseFilePath, HoodieInstant instantToRollback) throws IOException, InterruptedException {
        Path baseFilePathForAppend = new Path(this.basePath, appendBaseFilePath);
        String fileId = FSUtils.getFileIdFromFilePath((Path)baseFilePathForAppend);
        String baseCommitTime = FSUtils.getCommitTime((String)baseFilePathForAppend.getName());
        String partitionPath = FSUtils.getRelativePartitionPath((Path)new Path(this.basePath), (Path)new Path(this.basePath, appendBaseFilePath).getParent());
        Map<FileStatus, Long> writtenLogFileSizeMap = this.getWrittenLogFileSizeMap(partitionPath, baseCommitTime, fileId);
        HoodieLogFormat.Writer writer = null;
        try {
            Path partitionFullPath = FSUtils.getPartitionPath((String)this.basePath, (String)partitionPath);
            if (!this.table.getMetaClient().getFs().exists(partitionFullPath)) {
                HoodieRollbackStat hoodieRollbackStat = HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath).build();
                return hoodieRollbackStat;
            }
            writer = HoodieLogFormat.newWriterBuilder().onParentPath(partitionFullPath).withFileId(fileId).overBaseCommit(baseCommitTime).withFs((FileSystem)this.table.getMetaClient().getFs()).withFileExtension(".log").build();
            Map<HoodieLogBlock.HeaderMetadataType, String> header = RollbackUtils.generateHeader(instantToRollback.getTimestamp(), this.instantTime);
            writer.appendBlock((HoodieLogBlock)new HoodieCommandBlock(header));
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException io) {
                throw new HoodieIOException("Error closing append of rollback block..", io);
            }
        }
        Map<FileStatus, Long> filesToNumBlocksRollback = Collections.singletonMap(this.table.getMetaClient().getFs().getFileStatus(Objects.requireNonNull(writer).getLogFile().getPath()), 1L);
        return HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath).withRollbackBlockAppendResults(filesToNumBlocksRollback).withWrittenLogFileSizeMap(writtenLogFileSizeMap).build();
    }

    protected Map<FileStatus, Long> getWrittenLogFileSizeMap(String partitionPath, String baseCommitTime, String fileId) throws IOException {
        return Collections.EMPTY_MAP;
    }
}

