/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Timer;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMetrics {
    private static final Logger LOG = LogManager.getLogger(HoodieMetrics.class);
    public String rollbackTimerName = null;
    public String cleanTimerName = null;
    public String commitTimerName = null;
    public String deltaCommitTimerName = null;
    public String replaceCommitTimerName = null;
    public String finalizeTimerName = null;
    public String compactionTimerName = null;
    public String indexTimerName = null;
    private HoodieWriteConfig config;
    private String tableName;
    private Timer rollbackTimer = null;
    private Timer cleanTimer = null;
    private Timer commitTimer = null;
    private Timer deltaCommitTimer = null;
    private Timer finalizeTimer = null;
    private Timer compactionTimer = null;
    private Timer clusteringTimer = null;
    private Timer indexTimer = null;

    public HoodieMetrics(HoodieWriteConfig config) {
        this.config = config;
        this.tableName = config.getTableName();
        if (config.isMetricsOn()) {
            Metrics.init(config);
            this.rollbackTimerName = this.getMetricsName("timer", "rollback");
            this.cleanTimerName = this.getMetricsName("timer", "clean");
            this.commitTimerName = this.getMetricsName("timer", "commit");
            this.deltaCommitTimerName = this.getMetricsName("timer", "deltacommit");
            this.replaceCommitTimerName = this.getMetricsName("timer", "replacecommit");
            this.finalizeTimerName = this.getMetricsName("timer", "finalize");
            this.compactionTimerName = this.getMetricsName("timer", "compaction");
            this.indexTimerName = this.getMetricsName("timer", "index");
        }
    }

    private Timer createTimer(String name) {
        return this.config.isMetricsOn() ? Metrics.getInstance().getRegistry().timer(name) : null;
    }

    public Timer.Context getRollbackCtx() {
        if (this.config.isMetricsOn() && this.rollbackTimer == null) {
            this.rollbackTimer = this.createTimer(this.rollbackTimerName);
        }
        return this.rollbackTimer == null ? null : this.rollbackTimer.time();
    }

    public Timer.Context getCompactionCtx() {
        if (this.config.isMetricsOn() && this.compactionTimer == null) {
            this.compactionTimer = this.createTimer(this.commitTimerName);
        }
        return this.compactionTimer == null ? null : this.compactionTimer.time();
    }

    public Timer.Context getClusteringCtx() {
        if (this.config.isMetricsOn() && this.clusteringTimer == null) {
            this.clusteringTimer = this.createTimer(this.replaceCommitTimerName);
        }
        return this.clusteringTimer == null ? null : this.clusteringTimer.time();
    }

    public Timer.Context getCleanCtx() {
        if (this.config.isMetricsOn() && this.cleanTimer == null) {
            this.cleanTimer = this.createTimer(this.cleanTimerName);
        }
        return this.cleanTimer == null ? null : this.cleanTimer.time();
    }

    public Timer.Context getCommitCtx() {
        if (this.config.isMetricsOn() && this.commitTimer == null) {
            this.commitTimer = this.createTimer(this.commitTimerName);
        }
        return this.commitTimer == null ? null : this.commitTimer.time();
    }

    public Timer.Context getFinalizeCtx() {
        if (this.config.isMetricsOn() && this.finalizeTimer == null) {
            this.finalizeTimer = this.createTimer(this.finalizeTimerName);
        }
        return this.finalizeTimer == null ? null : this.finalizeTimer.time();
    }

    public Timer.Context getDeltaCommitCtx() {
        if (this.config.isMetricsOn() && this.deltaCommitTimer == null) {
            this.deltaCommitTimer = this.createTimer(this.deltaCommitTimerName);
        }
        return this.deltaCommitTimer == null ? null : this.deltaCommitTimer.time();
    }

    public Timer.Context getIndexCtx() {
        if (this.config.isMetricsOn() && this.indexTimer == null) {
            this.indexTimer = this.createTimer(this.indexTimerName);
        }
        return this.indexTimer == null ? null : this.indexTimer.time();
    }

    public void updateCommitMetrics(long commitEpochTimeInMs, long durationInMs, HoodieCommitMetadata metadata, String actionType) {
        this.updateCommitTimingMetrics(commitEpochTimeInMs, durationInMs, metadata, actionType);
        if (this.config.isMetricsOn()) {
            long totalPartitionsWritten = metadata.fetchTotalPartitionsWritten();
            long totalFilesInsert = metadata.fetchTotalFilesInsert();
            long totalFilesUpdate = metadata.fetchTotalFilesUpdated();
            long totalRecordsWritten = metadata.fetchTotalRecordsWritten();
            long totalUpdateRecordsWritten = metadata.fetchTotalUpdateRecordsWritten();
            long totalInsertRecordsWritten = metadata.fetchTotalInsertRecordsWritten();
            long totalBytesWritten = metadata.fetchTotalBytesWritten();
            long totalTimeTakenByScanner = metadata.getTotalScanTime();
            long totalTimeTakenForInsert = metadata.getTotalCreateTime();
            long totalTimeTakenForUpsert = metadata.getTotalUpsertTime();
            long totalCompactedRecordsUpdated = metadata.getTotalCompactedRecordsUpdated();
            long totalLogFilesCompacted = metadata.getTotalLogFilesCompacted();
            long totalLogFilesSize = metadata.getTotalLogFilesSize();
            Metrics.registerGauge(this.getMetricsName(actionType, "totalPartitionsWritten"), totalPartitionsWritten);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalFilesInsert"), totalFilesInsert);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalFilesUpdate"), totalFilesUpdate);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalRecordsWritten"), totalRecordsWritten);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalUpdateRecordsWritten"), totalUpdateRecordsWritten);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalInsertRecordsWritten"), totalInsertRecordsWritten);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalBytesWritten"), totalBytesWritten);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalScanTime"), totalTimeTakenByScanner);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalCreateTime"), totalTimeTakenForInsert);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalUpsertTime"), totalTimeTakenForUpsert);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalCompactedRecordsUpdated"), totalCompactedRecordsUpdated);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalLogFilesCompacted"), totalLogFilesCompacted);
            Metrics.registerGauge(this.getMetricsName(actionType, "totalLogFilesSize"), totalLogFilesSize);
        }
    }

    private void updateCommitTimingMetrics(long commitEpochTimeInMs, long durationInMs, HoodieCommitMetadata metadata, String actionType) {
        if (this.config.isMetricsOn()) {
            Pair eventTimePairMinMax = metadata.getMinAndMaxEventTime();
            if (((Option)eventTimePairMinMax.getLeft()).isPresent()) {
                long commitLatencyInMs = commitEpochTimeInMs + durationInMs - (Long)((Option)eventTimePairMinMax.getLeft()).get();
                Metrics.registerGauge(this.getMetricsName(actionType, "commitLatencyInMs"), commitLatencyInMs);
            }
            if (((Option)eventTimePairMinMax.getRight()).isPresent()) {
                long commitFreshnessInMs = commitEpochTimeInMs + durationInMs - (Long)((Option)eventTimePairMinMax.getRight()).get();
                Metrics.registerGauge(this.getMetricsName(actionType, "commitFreshnessInMs"), commitFreshnessInMs);
            }
            Metrics.registerGauge(this.getMetricsName(actionType, "commitTime"), commitEpochTimeInMs);
            Metrics.registerGauge(this.getMetricsName(actionType, "duration"), durationInMs);
        }
    }

    public void updateRollbackMetrics(long durationInMs, long numFilesDeleted) {
        if (this.config.isMetricsOn()) {
            LOG.info((Object)String.format("Sending rollback metrics (duration=%d, numFilesDeleted=%d)", durationInMs, numFilesDeleted));
            Metrics.registerGauge(this.getMetricsName("rollback", "duration"), durationInMs);
            Metrics.registerGauge(this.getMetricsName("rollback", "numFilesDeleted"), numFilesDeleted);
        }
    }

    public void updateCleanMetrics(long durationInMs, int numFilesDeleted) {
        if (this.config.isMetricsOn()) {
            LOG.info((Object)String.format("Sending clean metrics (duration=%d, numFilesDeleted=%d)", durationInMs, numFilesDeleted));
            Metrics.registerGauge(this.getMetricsName("clean", "duration"), durationInMs);
            Metrics.registerGauge(this.getMetricsName("clean", "numFilesDeleted"), numFilesDeleted);
        }
    }

    public void updateFinalizeWriteMetrics(long durationInMs, long numFilesFinalized) {
        if (this.config.isMetricsOn()) {
            LOG.info((Object)String.format("Sending finalize write metrics (duration=%d, numFilesFinalized=%d)", durationInMs, numFilesFinalized));
            Metrics.registerGauge(this.getMetricsName("finalize", "duration"), durationInMs);
            Metrics.registerGauge(this.getMetricsName("finalize", "numFilesFinalized"), numFilesFinalized);
        }
    }

    public void updateIndexMetrics(String action, long durationInMs) {
        if (this.config.isMetricsOn()) {
            LOG.info((Object)String.format("Sending index metrics (%s.duration, %d)", action, durationInMs));
            Metrics.registerGauge(this.getMetricsName("index", String.format("%s.duration", action)), durationInMs);
        }
    }

    String getMetricsName(String action, String metric) {
        return this.config == null ? null : String.format("%s.%s.%s", this.tableName, action, metric);
    }

    public long getDurationInMs(long ctxDuration) {
        return ctxDuration / 1000000L;
    }
}

