/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieConcatHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieMergeHandle<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieConcatHandle.class);

    public HoodieConcatHandle(HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, Iterator recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, hoodieTable, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
    }

    public HoodieConcatHandle(HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, Map keyToNewRecords, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, (Option<BaseKeyGenerator>)Option.empty());
    }

    @Override
    public void write(GenericRecord oldRecord) {
        String key = KeyGenUtils.getRecordKeyFromGenericRecord(oldRecord, (Option<BaseKeyGenerator>)this.keyGeneratorOpt);
        try {
            this.fileWriter.writeAvro(key, oldRecord);
        }
        catch (IOException | RuntimeException e) {
            String errMsg = String.format("Failed to write old record into new file for key %s from old file %s to new file %s with writerSchema %s", key, this.getOldFilePath(), this.newFilePath, this.writeSchemaWithMetaFields.toString(true));
            LOG.debug((Object)("Old record is " + oldRecord));
            throw new HoodieUpsertException(errMsg, e);
        }
        ++this.recordsWritten;
    }
}

