/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import com.beust.jcommander.internal.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBaseBloomIndexCheckFunction;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedIndexFileFilter;
import org.apache.hudi.io.HoodieKeyLookupHandle;
import org.apache.hudi.io.HoodieRangeInfoHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieBaseBloomIndex<T extends HoodieRecordPayload>
extends HoodieIndex<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(HoodieBaseBloomIndex.class);

    public HoodieBaseBloomIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public List<HoodieRecord<T>> tagLocation(List<HoodieRecord<T>> records, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> hoodieTable) {
        HashMap<String, List<String>> partitionRecordKeyMap = new HashMap<String, List<String>>();
        records.forEach(record -> {
            if (partitionRecordKeyMap.containsKey(record.getPartitionPath())) {
                ((List)partitionRecordKeyMap.get(record.getPartitionPath())).add(record.getRecordKey());
            } else {
                List recordKeys = Lists.newArrayList();
                recordKeys.add(record.getRecordKey());
                partitionRecordKeyMap.put(record.getPartitionPath(), recordKeys);
            }
        });
        Map<HoodieKey, HoodieRecordLocation> keyFilenamePairMap = this.lookupIndex(partitionRecordKeyMap, context, hoodieTable);
        if (LOG.isDebugEnabled()) {
            long totalTaggedRecords = keyFilenamePairMap.values().size();
            LOG.debug((Object)("Number of update records (ones tagged with a fileID): " + totalTaggedRecords));
        }
        List<HoodieRecord<T>> taggedRecords = this.tagLocationBacktoRecords(keyFilenamePairMap, records);
        return taggedRecords;
    }

    private Map<HoodieKey, HoodieRecordLocation> lookupIndex(Map<String, List<String>> partitionRecordKeyMap, HoodieEngineContext context, HoodieTable hoodieTable) {
        HashMap recordsPerPartition = new HashMap();
        partitionRecordKeyMap.keySet().forEach(k -> recordsPerPartition.put(k, Long.valueOf(((List)partitionRecordKeyMap.get(k)).size())));
        ArrayList<String> affectedPartitionPathList = new ArrayList<String>(recordsPerPartition.keySet());
        List<Pair<String, BloomIndexFileInfo>> fileInfoList = this.loadInvolvedFiles(affectedPartitionPathList, context, hoodieTable);
        Map<String, List<BloomIndexFileInfo>> partitionToFileInfo = fileInfoList.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        List<Pair<String, HoodieKey>> fileComparisons = this.explodeRecordsWithFileComparisons(partitionToFileInfo, partitionRecordKeyMap);
        return this.findMatchingFilesForRecordKeys(fileComparisons, hoodieTable);
    }

    List<Pair<String, BloomIndexFileInfo>> loadInvolvedFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        List partitionPathFileIDList = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, context, hoodieTable).stream().map(pair -> Pair.of((Object)pair.getKey(), (Object)((HoodieBaseFile)pair.getValue()).getFileId())).collect(Collectors.toList());
        if (this.config.getBloomIndexPruneByRanges()) {
            context.setJobStatus(this.getClass().getName(), "Obtain key ranges for file slices (range pruning=on)");
            return context.map(partitionPathFileIDList, (SerializableFunction & Serializable)pf -> {
                try {
                    HoodieRangeInfoHandle rangeInfoHandle = new HoodieRangeInfoHandle(this.config, hoodieTable, (Pair<String, String>)pf);
                    String[] minMaxKeys = rangeInfoHandle.getMinMaxKeys();
                    return Pair.of((Object)pf.getKey(), (Object)new BloomIndexFileInfo((String)pf.getValue(), minMaxKeys[0], minMaxKeys[1]));
                }
                catch (MetadataNotFoundException me) {
                    LOG.warn((Object)("Unable to find range metadata in file :" + pf));
                    return Pair.of((Object)pf.getKey(), (Object)new BloomIndexFileInfo((String)pf.getValue()));
                }
            }, Math.max(partitionPathFileIDList.size(), 1));
        }
        return partitionPathFileIDList.stream().map(pf -> Pair.of((Object)pf.getKey(), (Object)new BloomIndexFileInfo((String)pf.getValue()))).collect(Collectors.toList());
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    List<Pair<String, HoodieKey>> explodeRecordsWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, Map<String, List<String>> partitionRecordKeyMap) {
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedIndexFileFilter(partitionToFileIndexInfo) : new ListBasedIndexFileFilter(partitionToFileIndexInfo);
        ArrayList<Pair<String, HoodieKey>> fileRecordPairs = new ArrayList<Pair<String, HoodieKey>>();
        partitionRecordKeyMap.keySet().forEach(partitionPath -> {
            List hoodieRecordKeys = (List)partitionRecordKeyMap.get(partitionPath);
            hoodieRecordKeys.forEach(hoodieRecordKey -> indexFileFilter.getMatchingFilesAndPartition((String)partitionPath, (String)hoodieRecordKey).forEach(partitionFileIdPair -> fileRecordPairs.add(Pair.of((Object)partitionFileIdPair.getRight(), (Object)new HoodieKey(hoodieRecordKey, partitionPath)))));
        });
        return fileRecordPairs;
    }

    Map<HoodieKey, HoodieRecordLocation> findMatchingFilesForRecordKeys(List<Pair<String, HoodieKey>> fileComparisons, HoodieTable hoodieTable) {
        fileComparisons = fileComparisons.stream().sorted((o1, o2) -> ((String)o1.getLeft()).compareTo((String)o2.getLeft())).collect(Collectors.toList());
        List<Object> keyLookupResults = new ArrayList();
        Iterator<List<HoodieKeyLookupHandle.KeyLookupResult>> iterator = new HoodieBaseBloomIndexCheckFunction(hoodieTable, this.config).apply(fileComparisons.iterator());
        while (iterator.hasNext()) {
            keyLookupResults.addAll((Collection)iterator.next());
        }
        HashMap<HoodieKey, HoodieRecordLocation> hoodieRecordLocationMap = new HashMap<HoodieKey, HoodieRecordLocation>();
        keyLookupResults = keyLookupResults.stream().filter(lr -> lr.getMatchingRecordKeys().size() > 0).collect(Collectors.toList());
        keyLookupResults.forEach(lookupResult -> lookupResult.getMatchingRecordKeys().forEach(r -> hoodieRecordLocationMap.put(new HoodieKey(r, lookupResult.getPartitionPath()), new HoodieRecordLocation(lookupResult.getBaseInstantTime(), lookupResult.getFileId()))));
        return hoodieRecordLocationMap;
    }

    protected List<HoodieRecord<T>> tagLocationBacktoRecords(Map<HoodieKey, HoodieRecordLocation> keyFilenamePair, List<HoodieRecord<T>> records) {
        HashMap keyRecordPairMap = new HashMap();
        records.forEach(r -> keyRecordPairMap.put(r.getKey(), r));
        ArrayList newList = new ArrayList();
        keyRecordPairMap.keySet().forEach(k -> {
            if (keyFilenamePair.containsKey(k)) {
                newList.add(Pair.of(keyRecordPairMap.get(k), keyFilenamePair.get(k)));
            } else {
                newList.add(Pair.of(keyRecordPairMap.get(k), null));
            }
        });
        List res = Lists.newArrayList();
        for (Pair v : newList) {
            res.add(HoodieIndexUtils.getTaggedRecord((HoodieRecord)v.getLeft(), (Option<HoodieRecordLocation>)Option.ofNullable((Object)v.getRight())));
        }
        return res;
    }

    @Override
    public List<WriteStatus> updateLocation(List<WriteStatus> writeStatusList, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> hoodieTable) {
        return writeStatusList;
    }
}

