/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@Immutable
public class HoodiePreCommitValidatorConfig
extends HoodieConfig {
    public static final ConfigProperty<String> VALIDATOR_CLASS_NAMES = ConfigProperty.key((String)"hoodie.precommit.validators").defaultValue((Object)"").withDocumentation("Comma separated list of class names that can be invoked to validate commit");
    public static final String VALIDATOR_TABLE_VARIABLE = "<TABLE_NAME>";
    public static final ConfigProperty<String> EQUALITY_SQL_QUERIES = ConfigProperty.key((String)"hoodie.precommit.validators.equality.sql.queries").defaultValue((Object)"").withDocumentation("Spark SQL queries to run on table before committing new data to validate state before and after commit. Multiple queries separated by ';' delimiter are supported. Example: \"select count(*) from \\<TABLE_NAME\\> Note \\<TABLE_NAME\\> is replaced by table state before and after commit.");
    public static final ConfigProperty<String> SINGLE_VALUE_SQL_QUERIES = ConfigProperty.key((String)"hoodie.precommit.validators.single.value.sql.queries").defaultValue((Object)"").withDocumentation("Spark SQL queries to run on table before committing new data to validate state after commit.Multiple queries separated by ';' delimiter are supported.Expected result is included as part of query separated by '#'. Example query: 'query1#result1:query2#result2'Note \\<TABLE_NAME\\> variable is expected to be present in query.");
    public static final ConfigProperty<String> INEQUALITY_SQL_QUERIES = ConfigProperty.key((String)"hoodie.precommit.validators.inequality.sql.queries").defaultValue((Object)"").withDocumentation("Spark SQL queries to run on table before committing new data to validate state before and after commit.Multiple queries separated by ';' delimiter are supported.Example query: 'select count(*) from \\<TABLE_NAME\\> where col=null'Note \\<TABLE_NAME\\> variable is expected to be present in query.");

    private HoodiePreCommitValidatorConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodiePreCommitValidatorConfig preCommitValidatorConfig = new HoodiePreCommitValidatorConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.preCommitValidatorConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.preCommitValidatorConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withPreCommitValidator(String preCommitValidators) {
            this.preCommitValidatorConfig.setValue(VALIDATOR_CLASS_NAMES, preCommitValidators);
            return this;
        }

        public Builder withPrecommitValidatorEqualitySqlQueries(String preCommitValidators) {
            this.preCommitValidatorConfig.setValue(EQUALITY_SQL_QUERIES, preCommitValidators);
            return this;
        }

        public Builder withPrecommitValidatorSingleResultSqlQueries(String preCommitValidators) {
            this.preCommitValidatorConfig.setValue(SINGLE_VALUE_SQL_QUERIES, preCommitValidators);
            return this;
        }

        public Builder withPrecommitValidatorInequalitySqlQueries(String preCommitValidators) {
            this.preCommitValidatorConfig.setValue(INEQUALITY_SQL_QUERIES, preCommitValidators);
            return this;
        }

        public HoodiePreCommitValidatorConfig build() {
            this.preCommitValidatorConfig.setDefaults(HoodiePreCommitValidatorConfig.class.getName());
            return this.preCommitValidatorConfig;
        }
    }
}

