/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metrics Configurations for Prometheus", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics using Prometheus.  Hudi publishes metrics on every commit, clean, rollback etc.")
public class HoodieMetricsPrometheusConfig
extends HoodieConfig {
    public static final String PUSHGATEWAY_PREFIX = "hoodie.metrics.pushgateway";
    public static final ConfigProperty<String> PUSHGATEWAY_HOST_NAME = ConfigProperty.key((String)"hoodie.metrics.pushgateway.host").defaultValue((Object)"localhost").sinceVersion("0.6.0").withDocumentation("Hostname of the prometheus push gateway");
    public static final ConfigProperty<Integer> PUSHGATEWAY_PORT_NUM = ConfigProperty.key((String)"hoodie.metrics.pushgateway.port").defaultValue((Object)9091).sinceVersion("0.6.0").withDocumentation("Port for the push gateway.");
    public static final ConfigProperty<Integer> PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS = ConfigProperty.key((String)"hoodie.metrics.pushgateway.report.period.seconds").defaultValue((Object)30).sinceVersion("0.6.0").withDocumentation("Reporting interval in seconds.");
    public static final ConfigProperty<Boolean> PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE = ConfigProperty.key((String)"hoodie.metrics.pushgateway.delete.on.shutdown").defaultValue((Object)true).sinceVersion("0.6.0").withDocumentation("");
    public static final ConfigProperty<String> PUSHGATEWAY_JOBNAME = ConfigProperty.key((String)"hoodie.metrics.pushgateway.job.name").defaultValue((Object)"").sinceVersion("0.6.0").withDocumentation("Name of the push gateway job.");
    public static final ConfigProperty<Boolean> PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX = ConfigProperty.key((String)"hoodie.metrics.pushgateway.random.job.name.suffix").defaultValue((Object)true).sinceVersion("0.6.0").withDocumentation("");
    public static final String PROMETHEUS_PREFIX = "hoodie.metrics.prometheus";
    public static final ConfigProperty<Integer> PROMETHEUS_PORT_NUM = ConfigProperty.key((String)"hoodie.metrics.prometheus.port").defaultValue((Object)9090).sinceVersion("0.6.0").withDocumentation("Port for prometheus server.");
    @Deprecated
    public static final String PUSHGATEWAY_HOST = PUSHGATEWAY_HOST_NAME.key();
    @Deprecated
    public static final String DEFAULT_PUSHGATEWAY_HOST = (String)PUSHGATEWAY_HOST_NAME.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_PORT = PUSHGATEWAY_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_PUSHGATEWAY_PORT = (Integer)PUSHGATEWAY_PORT_NUM.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_REPORT_PERIOD_SECONDS = PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS.key();
    @Deprecated
    public static final int DEFAULT_PUSHGATEWAY_REPORT_PERIOD_SECONDS = (Integer)PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_DELETE_ON_SHUTDOWN = PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_PUSHGATEWAY_DELETE_ON_SHUTDOWN = (Boolean)PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_JOB_NAME = PUSHGATEWAY_JOBNAME.key();
    @Deprecated
    public static final String DEFAULT_PUSHGATEWAY_JOB_NAME = (String)PUSHGATEWAY_JOBNAME.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_RANDOM_JOB_NAME_SUFFIX = PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX.key();
    @Deprecated
    public static final boolean DEFAULT_PUSHGATEWAY_RANDOM_JOB_NAME_SUFFIX = (Boolean)PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX.defaultValue();
    @Deprecated
    public static final String PROMETHEUS_PORT = PROMETHEUS_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_PROMETHEUS_PORT = (Integer)PROMETHEUS_PORT_NUM.defaultValue();

    private HoodieMetricsPrometheusConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Properties getProps() {
        return super.getProps();
    }

    public static class Builder {
        private HoodieMetricsPrometheusConfig hoodieMetricsPrometheusConfig = new HoodieMetricsPrometheusConfig();

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsPrometheusConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public HoodieMetricsPrometheusConfig build() {
            this.hoodieMetricsPrometheusConfig.setDefaults(HoodieMetricsPrometheusConfig.class.getName());
            return this.hoodieMetricsPrometheusConfig;
        }
    }
}

