/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.config.HoodieMetricsDatadogConfig;
import org.apache.hudi.config.HoodieMetricsPrometheusConfig;
import org.apache.hudi.metrics.MetricsReporterType;

@ConfigClassProperty(name="Metrics Configurations", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics. Hudi publishes metrics on every commit, clean, rollback etc. The following sections list the supported reporters.")
@Immutable
public class HoodieMetricsConfig
extends HoodieConfig {
    public static final String METRIC_PREFIX = "hoodie.metrics";
    public static final ConfigProperty<Boolean> TURN_METRICS_ON = ConfigProperty.key((String)"hoodie.metrics.on").defaultValue((Object)false).sinceVersion("0.5.0").withDocumentation("Turn on/off metrics reporting. off by default.");
    public static final ConfigProperty<MetricsReporterType> METRICS_REPORTER_TYPE_VALUE = ConfigProperty.key((String)"hoodie.metrics.reporter.type").defaultValue((Object)MetricsReporterType.GRAPHITE).sinceVersion("0.5.0").withDocumentation("Type of metrics reporter.");
    public static final String GRAPHITE_PREFIX = "hoodie.metrics.graphite";
    public static final ConfigProperty<String> GRAPHITE_SERVER_HOST_NAME = ConfigProperty.key((String)"hoodie.metrics.graphite.host").defaultValue((Object)"localhost").sinceVersion("0.5.0").withDocumentation("Graphite host to connect to");
    public static final ConfigProperty<Integer> GRAPHITE_SERVER_PORT_NUM = ConfigProperty.key((String)"hoodie.metrics.graphite.port").defaultValue((Object)4756).sinceVersion("0.5.0").withDocumentation("Graphite port to connect to");
    public static final String JMX_PREFIX = "hoodie.metrics.jmx";
    public static final ConfigProperty<String> JMX_HOST_NAME = ConfigProperty.key((String)"hoodie.metrics.jmx.host").defaultValue((Object)"localhost").sinceVersion("0.5.1").withDocumentation("Jmx host to connect to");
    public static final ConfigProperty<Integer> JMX_PORT_NUM = ConfigProperty.key((String)"hoodie.metrics.jmx.port").defaultValue((Object)9889).sinceVersion("0.5.1").withDocumentation("Jmx port to connect to");
    public static final ConfigProperty<String> GRAPHITE_METRIC_PREFIX_VALUE = ConfigProperty.key((String)"hoodie.metrics.graphite.metric.prefix").noDefaultValue().sinceVersion("0.5.1").withDocumentation("Standard prefix applied to all metrics. This helps to add datacenter, environment information for e.g");
    public static final ConfigProperty<String> METRICS_REPORTER_CLASS_NAME = ConfigProperty.key((String)"hoodie.metrics.reporter.class").defaultValue((Object)"").sinceVersion("0.6.0").withDocumentation("");
    public static final ConfigProperty<String> EXECUTOR_METRICS_ENABLE = ConfigProperty.key((String)"hoodie.metrics.executor.enable").noDefaultValue().sinceVersion("0.7.0").withDocumentation("");
    @Deprecated
    public static final String METRICS_ON = TURN_METRICS_ON.key();
    @Deprecated
    public static final boolean DEFAULT_METRICS_ON = (Boolean)TURN_METRICS_ON.defaultValue();
    @Deprecated
    public static final String METRICS_REPORTER_TYPE = METRICS_REPORTER_TYPE_VALUE.key();
    @Deprecated
    public static final MetricsReporterType DEFAULT_METRICS_REPORTER_TYPE = (MetricsReporterType)((Object)METRICS_REPORTER_TYPE_VALUE.defaultValue());
    @Deprecated
    public static final String GRAPHITE_SERVER_HOST = GRAPHITE_SERVER_HOST_NAME.key();
    @Deprecated
    public static final String DEFAULT_GRAPHITE_SERVER_HOST = (String)GRAPHITE_SERVER_HOST_NAME.defaultValue();
    @Deprecated
    public static final String GRAPHITE_SERVER_PORT = GRAPHITE_SERVER_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_GRAPHITE_SERVER_PORT = (Integer)GRAPHITE_SERVER_PORT_NUM.defaultValue();
    @Deprecated
    public static final String JMX_HOST = JMX_HOST_NAME.key();
    @Deprecated
    public static final String DEFAULT_JMX_HOST = (String)JMX_HOST_NAME.defaultValue();
    @Deprecated
    public static final String JMX_PORT = JMX_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_JMX_PORT = (Integer)JMX_PORT_NUM.defaultValue();
    @Deprecated
    public static final String GRAPHITE_METRIC_PREFIX = GRAPHITE_METRIC_PREFIX_VALUE.key();
    @Deprecated
    public static final String METRICS_REPORTER_CLASS = METRICS_REPORTER_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_METRICS_REPORTER_CLASS = (String)METRICS_REPORTER_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String ENABLE_EXECUTOR_METRICS = EXECUTOR_METRICS_ENABLE.key();

    private HoodieMetricsConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMetricsConfig hoodieMetricsConfig = new HoodieMetricsConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.hoodieMetricsConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder on(boolean metricsOn) {
            this.hoodieMetricsConfig.setValue(TURN_METRICS_ON, String.valueOf(metricsOn));
            return this;
        }

        public Builder withReporterType(String reporterType) {
            this.hoodieMetricsConfig.setValue(METRICS_REPORTER_TYPE_VALUE, reporterType);
            return this;
        }

        public Builder toGraphiteHost(String host) {
            this.hoodieMetricsConfig.setValue(GRAPHITE_SERVER_HOST_NAME, host);
            return this;
        }

        public Builder onGraphitePort(int port) {
            this.hoodieMetricsConfig.setValue(GRAPHITE_SERVER_PORT_NUM, String.valueOf(port));
            return this;
        }

        public Builder toJmxHost(String host) {
            this.hoodieMetricsConfig.setValue(JMX_HOST_NAME, host);
            return this;
        }

        public Builder onJmxPort(String port) {
            this.hoodieMetricsConfig.setValue(JMX_PORT_NUM, port);
            return this;
        }

        public Builder usePrefix(String prefix) {
            this.hoodieMetricsConfig.setValue(GRAPHITE_METRIC_PREFIX_VALUE, prefix);
            return this;
        }

        public Builder withReporterClass(String className) {
            this.hoodieMetricsConfig.setValue(METRICS_REPORTER_CLASS_NAME, className);
            return this;
        }

        public Builder withExecutorMetrics(boolean enable) {
            this.hoodieMetricsConfig.setValue(EXECUTOR_METRICS_ENABLE, String.valueOf(enable));
            return this;
        }

        public HoodieMetricsConfig build() {
            this.hoodieMetricsConfig.setDefaults(HoodieMetricsConfig.class.getName());
            MetricsReporterType reporterType = MetricsReporterType.valueOf(this.hoodieMetricsConfig.getString(METRICS_REPORTER_TYPE_VALUE));
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.DATADOG, HoodieMetricsDatadogConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.PROMETHEUS_PUSHGATEWAY, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.PROMETHEUS, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            return this.hoodieMetricsConfig;
        }
    }
}

