/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TransactionUtils {
    private static final Logger LOG = LogManager.getLogger(TransactionUtils.class);

    public static Option<HoodieCommitMetadata> resolveWriteConflictIfAny(HoodieTable table, Option<HoodieInstant> currentTxnOwnerInstant, Option<HoodieCommitMetadata> thisCommitMetadata, HoodieWriteConfig config, Option<HoodieInstant> lastCompletedTxnOwnerInstant) throws HoodieWriteConflictException {
        if (config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            ConflictResolutionStrategy resolutionStrategy = config.getWriteConflictResolutionStrategy();
            Stream<HoodieInstant> instantStream = resolutionStrategy.getCandidateInstants(table.getActiveTimeline(), (HoodieInstant)currentTxnOwnerInstant.get(), lastCompletedTxnOwnerInstant);
            ConcurrentOperation thisOperation = new ConcurrentOperation((HoodieInstant)currentTxnOwnerInstant.get(), (HoodieCommitMetadata)thisCommitMetadata.get());
            instantStream.forEach(instant -> {
                try {
                    ConcurrentOperation otherOperation = new ConcurrentOperation((HoodieInstant)instant, table.getMetaClient());
                    if (resolutionStrategy.hasConflict(thisOperation, otherOperation)) {
                        LOG.info((Object)("Conflict encountered between current instant = " + thisOperation + " and instant = " + otherOperation + ", attempting to resolve it..."));
                        resolutionStrategy.resolveConflict(table, thisOperation, otherOperation);
                    }
                }
                catch (IOException io) {
                    throw new HoodieWriteConflictException("Unable to resolve conflict, if present", (Throwable)io);
                }
            });
            LOG.info((Object)"Successfully resolved conflicts, if any");
            TransactionUtils.overrideWithLatestCommitMetadata(table.getMetaClient(), thisOperation.getCommitMetadataOption(), currentTxnOwnerInstant, Arrays.asList(config.getWriteMetaKeyPrefixes().split(",")));
            return thisOperation.getCommitMetadataOption();
        }
        return thisCommitMetadata;
    }

    public static Option<Pair<HoodieInstant, Map<String, String>>> getLastCompletedTxnInstantAndMetadata(HoodieTableMetaClient metaClient) {
        Option hoodieInstantOption = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant();
        try {
            if (hoodieInstantOption.isPresent()) {
                switch (((HoodieInstant)hoodieInstantOption.get()).getAction()) {
                    case "replacecommit": {
                        HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails((HoodieInstant)hoodieInstantOption.get()).get()), HoodieReplaceCommitMetadata.class);
                        return Option.of((Object)Pair.of((Object)hoodieInstantOption.get(), (Object)replaceCommitMetadata.getExtraMetadata()));
                    }
                    case "deltacommit": 
                    case "commit": {
                        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails((HoodieInstant)hoodieInstantOption.get()).get()), HoodieCommitMetadata.class);
                        return Option.of((Object)Pair.of((Object)hoodieInstantOption.get(), (Object)commitMetadata.getExtraMetadata()));
                    }
                }
                throw new IllegalArgumentException("Unknown instant action" + ((HoodieInstant)hoodieInstantOption.get()).getAction());
            }
            return Option.empty();
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read metadata for instant " + hoodieInstantOption.get(), io);
        }
    }

    private static void overrideWithLatestCommitMetadata(HoodieTableMetaClient metaClient, Option<HoodieCommitMetadata> thisMetadata, Option<HoodieInstant> thisInstant, List<String> keyPrefixes) {
        if (keyPrefixes.size() == 1 && keyPrefixes.get(0).length() < 1) {
            return;
        }
        Option<Pair<HoodieInstant, Map<String, String>>> lastInstant = TransactionUtils.getLastCompletedTxnInstantAndMetadata(metaClient);
        if (lastInstant.isPresent() && thisMetadata.isPresent()) {
            Stream keys = ((HoodieCommitMetadata)thisMetadata.get()).getExtraMetadata().keySet().stream();
            keyPrefixes.stream().forEach(keyPrefix -> keys.filter(key -> key.startsWith((String)keyPrefix)).forEach(key -> {
                String cfr_ignored_0 = (String)((HoodieCommitMetadata)thisMetadata.get()).getExtraMetadata().put(key, ((Map)((Pair)lastInstant.get()).getRight()).get(key));
            }));
        }
    }
}

