/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.heartbeat;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HeartbeatUtils {
    private static final Logger LOG = LogManager.getLogger(HeartbeatUtils.class);

    public static boolean deleteHeartbeatFile(FileSystem fs, String basePath, String instantTime) {
        boolean deleted = false;
        try {
            String heartbeatFolderPath = HoodieTableMetaClient.getHeartbeatFolderPath((String)basePath);
            deleted = fs.delete(new Path(heartbeatFolderPath + File.separator + instantTime), false);
            if (!deleted) {
                LOG.error((Object)("Failed to delete heartbeat for instant " + instantTime));
            }
        }
        catch (IOException io) {
            LOG.error((Object)("Unable to delete heartbeat for instant " + instantTime), (Throwable)io);
        }
        return deleted;
    }

    public static void cleanExpiredHeartbeats(List<String> allExistingHeartbeatInstants, HoodieTableMetaClient metaClient, String basePath) {
        Set nonExpiredHeartbeatInstants = metaClient.getActiveTimeline().filterCompletedInstants().getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
        allExistingHeartbeatInstants.stream().forEach(instant -> {
            if (!nonExpiredHeartbeatInstants.contains(instant)) {
                HeartbeatUtils.deleteHeartbeatFile((FileSystem)metaClient.getFs(), basePath, instant);
            }
        });
    }

    public static void abortIfHeartbeatExpired(String instantTime, HoodieTable table, HoodieHeartbeatClient heartbeatClient, HoodieWriteConfig config) {
        ValidationUtils.checkArgument((heartbeatClient != null ? 1 : 0) != 0);
        try {
            if (config.getFailedWritesCleanPolicy().isLazy() && heartbeatClient.isHeartbeatExpired(instantTime)) {
                throw new HoodieException("Heartbeat for instant " + instantTime + " has expired, last heartbeat " + HoodieHeartbeatClient.getLastHeartbeatTime((FileSystem)table.getMetaClient().getFs(), config.getBasePath(), instantTime));
            }
        }
        catch (IOException io) {
            throw new HoodieException("Unable to read heartbeat", (Throwable)io);
        }
    }
}

