/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractUpgradeDowngrade {
    private static final Logger LOG = LogManager.getLogger(AbstractUpgradeDowngrade.class);
    public static final String HOODIE_UPDATED_PROPERTY_FILE = "hoodie.properties.updated";
    private HoodieTableMetaClient metaClient;
    protected HoodieWriteConfig config;
    protected HoodieEngineContext context;
    private transient FileSystem fs;
    private Path updatedPropsFilePath;
    private Path propsFilePath;

    public abstract void run(HoodieTableMetaClient var1, HoodieTableVersion var2, HoodieWriteConfig var3, HoodieEngineContext var4, String var5);

    public boolean needsUpgradeOrDowngrade(HoodieTableVersion toVersion) {
        HoodieTableVersion fromVersion = this.metaClient.getTableConfig().getTableVersion();
        return toVersion.versionCode() != fromVersion.versionCode();
    }

    protected AbstractUpgradeDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieEngineContext context) {
        this.metaClient = metaClient;
        this.config = config;
        this.context = context;
        this.fs = metaClient.getFs();
        this.updatedPropsFilePath = new Path(metaClient.getMetaPath(), HOODIE_UPDATED_PROPERTY_FILE);
        this.propsFilePath = new Path(metaClient.getMetaPath(), "hoodie.properties");
    }

    protected void run(HoodieTableVersion toVersion, String instantTime) throws IOException {
        HoodieTableVersion fromVersion = this.metaClient.getTableConfig().getTableVersion();
        if (!this.needsUpgradeOrDowngrade(toVersion)) {
            return;
        }
        if (this.fs.exists(this.updatedPropsFilePath)) {
            LOG.info((Object)("Deleting existing .updated file with content :" + FileIOUtils.readAsUTFString((InputStream)this.fs.open(this.updatedPropsFilePath))));
            this.fs.delete(this.updatedPropsFilePath, false);
        }
        LOG.info((Object)("Attempting to move table from version " + fromVersion + " to " + toVersion));
        if (fromVersion.versionCode() < toVersion.versionCode()) {
            this.upgrade(fromVersion, toVersion, instantTime);
        } else {
            this.downgrade(fromVersion, toVersion, instantTime);
        }
        this.metaClient.getTableConfig().setTableVersion(toVersion);
        this.createUpdatedFile(this.metaClient.getTableConfig().getProperties());
        if (this.fs.exists(this.propsFilePath)) {
            this.fs.delete(this.propsFilePath, false);
        }
        this.fs.rename(this.updatedPropsFilePath, this.propsFilePath);
    }

    private void createUpdatedFile(Properties props) throws IOException {
        try (FSDataOutputStream outputStream = this.fs.create(this.updatedPropsFilePath);){
            props.store((OutputStream)outputStream, "Properties saved on " + new Date(System.currentTimeMillis()));
        }
    }

    protected abstract void upgrade(HoodieTableVersion var1, HoodieTableVersion var2, String var3);

    protected abstract void downgrade(HoodieTableVersion var1, HoodieTableVersion var2, String var3);
}

