/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseCopyOnWriteRollbackActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseRollbackActionExecutor<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(BaseCopyOnWriteRollbackActionExecutor.class);

    public BaseCopyOnWriteRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants) {
        super(context, config, table, instantTime, commitInstant, deleteInstants);
    }

    public BaseCopyOnWriteRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipTimelinePublish, boolean useMarkerBasedStrategy) {
        super(context, config, table, instantTime, commitInstant, deleteInstants, skipTimelinePublish, useMarkerBasedStrategy);
    }

    @Override
    protected List<HoodieRollbackStat> executeRollback() {
        HoodieTimer rollbackTimer = new HoodieTimer();
        rollbackTimer.startTimer();
        ArrayList<HoodieRollbackStat> stats = new ArrayList();
        HoodieActiveTimeline activeTimeline = this.table.getActiveTimeline();
        HoodieInstant resolvedInstant = this.instantToRollback;
        if (this.instantToRollback.isCompleted()) {
            LOG.info((Object)("Unpublishing instant " + this.instantToRollback));
            resolvedInstant = activeTimeline.revertToInflight(this.instantToRollback);
            this.table.getMetaClient().reloadActiveTimeline();
        }
        if (!resolvedInstant.isRequested()) {
            LOG.info((Object)("Clean out all base files generated for commit: " + resolvedInstant));
            stats = this.getRollbackStrategy().execute(resolvedInstant);
        }
        this.dropBootstrapIndexIfNeeded(this.instantToRollback);
        this.deleteInflightAndRequestedInstant(this.deleteInstants, activeTimeline, resolvedInstant);
        LOG.info((Object)("Time(in ms) taken to finish rollback " + rollbackTimer.endTimer()));
        return stats;
    }
}

