/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseRestoreActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieRestoreMetadata> {
    private static final Logger LOG = LogManager.getLogger(BaseRestoreActionExecutor.class);
    private final String restoreInstantTime;

    public BaseRestoreActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String restoreInstantTime) {
        super(context, config, table, instantTime);
        this.restoreInstantTime = restoreInstantTime;
    }

    @Override
    public HoodieRestoreMetadata execute() {
        HoodieTimer restoreTimer = new HoodieTimer();
        restoreTimer.startTimer();
        List<HoodieInstant> instantsToRollback = this.table.getActiveTimeline().getWriteTimeline().getReverseOrderedInstants().filter(instant -> HoodieActiveTimeline.GREATER_THAN.test(instant.getTimestamp(), this.restoreInstantTime)).collect(Collectors.toList());
        HashMap<String, List<HoodieRollbackMetadata>> instantToMetadata = new HashMap<String, List<HoodieRollbackMetadata>>();
        this.table.getActiveTimeline().createNewInstant(new HoodieInstant(true, "restore", this.instantTime));
        instantsToRollback.forEach(instant -> {
            instantToMetadata.put(instant.getTimestamp(), Collections.singletonList(this.rollbackInstant((HoodieInstant)instant)));
            LOG.info((Object)("Deleted instant " + instant));
        });
        try {
            return this.finishRestore(instantToMetadata, instantsToRollback, restoreTimer.endTimer());
        }
        catch (IOException io) {
            throw new HoodieRollbackException("unable to rollback instants " + instantsToRollback, io);
        }
    }

    protected abstract HoodieRollbackMetadata rollbackInstant(HoodieInstant var1);

    private HoodieRestoreMetadata finishRestore(Map<String, List<HoodieRollbackMetadata>> instantToMetadata, List<HoodieInstant> instantsRolledBack, long durationInMs) throws IOException {
        HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.convertRestoreMetadata((String)this.instantTime, (long)durationInMs, instantsRolledBack, instantToMetadata);
        this.table.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "restore", this.instantTime), TimelineMetadataUtils.serializeRestoreMetadata((HoodieRestoreMetadata)restoreMetadata));
        LOG.info((Object)("Commits " + instantsRolledBack + " rollback is complete. Restored table to " + this.restoreInstantTime));
        return restoreMetadata;
    }
}

