/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;

public abstract class BaseScheduleCompactionActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieCompactionPlan>> {
    private final Option<Map<String, String>> extraMetadata;

    public BaseScheduleCompactionActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
    }

    protected abstract HoodieCompactionPlan scheduleCompaction();

    @Override
    public Option<HoodieCompactionPlan> execute() {
        HoodieCompactionPlan plan;
        if (!this.config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl() && !this.config.getFailedWritesCleanPolicy().isLazy()) {
            this.table.getActiveTimeline().getCommitsTimeline().filterPendingExcludingCompaction().firstInstant().ifPresent(earliestInflight -> ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)earliestInflight.getTimestamp(), (BiPredicate)HoodieTimeline.GREATER_THAN, (String)this.instantTime), (String)("Earliest write inflight instant time must be later than compaction time. Earliest :" + earliestInflight + ", Compaction scheduled at " + this.instantTime)));
            List conflictingInstants = this.table.getActiveTimeline().getWriteTimeline().getInstants().filter(instant -> HoodieTimeline.compareTimestamps((String)instant.getTimestamp(), (BiPredicate)HoodieTimeline.GREATER_THAN_OR_EQUALS, (String)this.instantTime)).collect(Collectors.toList());
            ValidationUtils.checkArgument((boolean)conflictingInstants.isEmpty(), (String)("Following instants have timestamps >= compactionInstant (" + this.instantTime + ") Instants :" + conflictingInstants));
        }
        if ((plan = this.scheduleCompaction()) != null && plan.getOperations() != null && !plan.getOperations().isEmpty()) {
            this.extraMetadata.ifPresent(arg_0 -> ((HoodieCompactionPlan)plan).setExtraMetadata(arg_0));
            HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", this.instantTime);
            try {
                this.table.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)plan));
            }
            catch (IOException ioe) {
                throw new HoodieIOException("Exception scheduling compaction", ioe);
            }
            return Option.of((Object)plan);
        }
        return Option.empty();
    }
}

