/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.table.HoodieTable;

public abstract class AbstractCompactHelpers<T extends HoodieRecordPayload, I, K, O> {
    public abstract HoodieCommitMetadata createCompactionMetadata(HoodieTable<T, I, K, O> var1, String var2, O var3, String var4) throws IOException;

    public void completeInflightCompaction(HoodieTable table, String compactionCommitTime, HoodieCommitMetadata commitMetadata) {
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        try {
            activeTimeline.transitionCompactionInflightToComplete(new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionCommitTime), Option.of((Object)commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new HoodieCompactionException("Failed to commit " + table.getMetaClient().getBasePath() + " at time " + compactionCommitTime, e);
        }
    }
}

