/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.clean;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseCleanPlanActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieCleanerPlan>> {
    private static final Logger LOG = LogManager.getLogger(CleanPlanner.class);
    private final Option<Map<String, String>> extraMetadata;

    public BaseCleanPlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
    }

    protected abstract Option<HoodieCleanerPlan> createCleanerPlan();

    HoodieCleanerPlan requestClean(HoodieEngineContext context) {
        try {
            CleanPlanner planner = new CleanPlanner(context, this.table, this.config);
            Option<HoodieInstant> earliestInstant = planner.getEarliestCommitToRetain();
            List<String> partitionsToClean = planner.getPartitionPathsToClean(earliestInstant);
            if (partitionsToClean.isEmpty()) {
                LOG.info((Object)"Nothing to clean here. It is already clean");
                return HoodieCleanerPlan.newBuilder().setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).build();
            }
            LOG.info((Object)("Total Partitions to clean : " + partitionsToClean.size() + ", with policy " + this.config.getCleanerPolicy()));
            int cleanerParallelism = Math.min(partitionsToClean.size(), this.config.getCleanerParallelism());
            LOG.info((Object)("Using cleanerParallelism: " + cleanerParallelism));
            context.setJobStatus(this.getClass().getSimpleName(), "Generates list of file slices to be cleaned");
            Map<String, List> cleanOps = context.map(partitionsToClean, (SerializableFunction & Serializable)partitionPathToClean -> Pair.of((Object)partitionPathToClean, planner.getDeletePaths((String)partitionPathToClean)), cleanerParallelism).stream().collect(Collectors.toMap(Pair::getKey, y -> CleanerUtils.convertToHoodieCleanFileInfoList((List)((List)y.getValue()))));
            return new HoodieCleanerPlan((HoodieActionInstant)earliestInstant.map(x -> new HoodieActionInstant(x.getTimestamp(), x.getAction(), x.getState().name())).orElse(null), this.config.getCleanerPolicy().name(), CollectionUtils.createImmutableMap((Pair[])new Pair[0]), CleanPlanner.LATEST_CLEAN_PLAN_VERSION, cleanOps);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to schedule clean operation", e);
        }
    }

    protected Option<HoodieCleanerPlan> requestClean(String startCleanTime) {
        HoodieCleanerPlan cleanerPlan = this.requestClean(this.context);
        if (cleanerPlan.getFilePathsToBeDeletedPerPartition() != null && !cleanerPlan.getFilePathsToBeDeletedPerPartition().isEmpty() && cleanerPlan.getFilePathsToBeDeletedPerPartition().values().stream().mapToInt(List::size).sum() > 0) {
            HoodieInstant cleanInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", startCleanTime);
            try {
                this.table.getActiveTimeline().saveToCleanRequested(cleanInstant, TimelineMetadataUtils.serializeCleanerPlan((HoodieCleanerPlan)cleanerPlan));
                LOG.info((Object)("Requesting Cleaning with instant time " + cleanInstant));
            }
            catch (IOException e) {
                LOG.error((Object)"Got exception when saving cleaner requested file", (Throwable)e);
                throw new HoodieIOException(e.getMessage(), e);
            }
            return Option.of((Object)cleanerPlan);
        }
        return Option.empty();
    }

    @Override
    public Option<HoodieCleanerPlan> execute() {
        return this.requestClean(this.instantTime);
    }
}

